package de.flapdoodle.embed.process.types;

import java.util.Objects;

/**
 * Immutable implementation of {@link _DownloadPath}.
 * <p>
 * Use the static factory method to create immutable instances:
 * {@code DownloadPath.of()}.
 */
@SuppressWarnings({"all"})
public final class DownloadPath extends de.flapdoodle.embed.process.types._DownloadPath {
  private final String value;

  private DownloadPath(String value) {
    this.value = Objects.requireNonNull(value, "value");
  }

  /**
   * @return The value of the {@code value} attribute
   */
  @Override
  public String value() {
    return value;
  }

  /**
   * This instance is equal to all instances of {@code DownloadPath} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof DownloadPath
        && equalTo(0, (DownloadPath) another);
  }

  private boolean equalTo(int synthetic, DownloadPath another) {
    return value.equals(another.value);
  }

  /**
   * Computes a hash code from attributes: {@code value}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + value.hashCode();
    return h;
  }

  /**
   * Construct a new immutable {@code DownloadPath} instance.
   * @param value The value for the {@code value} attribute
   * @return An immutable DownloadPath instance
   */
  public static DownloadPath of(String value) {
    return new DownloadPath(value);
  }
}
