/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.process.io.progress;

import de.flapdoodle.embed.process.io.Slf4jLevel;
import de.flapdoodle.embed.process.io.progress.ProgressListener;
import org.slf4j.Logger;

public class Slf4jProgressListener
implements ProgressListener {
    private final Logger logger;
    private final Slf4jLevel level;
    private int lastPercent = -1;

    public Slf4jProgressListener(Logger logger) {
        this(logger, Slf4jLevel.INFO);
    }

    public Slf4jProgressListener(Logger logger, Slf4jLevel level) {
        this.logger = logger;
        this.level = level;
    }

    @Override
    public void progress(String label, int percent) {
        if (percent != this.lastPercent && percent % 10 == 0) {
            this.level.log(this.logger, "{} : {} %", label, percent);
        }
        this.lastPercent = percent;
    }

    @Override
    public void done(String label) {
        this.level.log(this.logger, "{} : finished", label);
    }

    @Override
    public void start(String label) {
        this.level.log(this.logger, "{} : starting...", label);
    }

    @Override
    public void info(String label, String message) {
        this.level.log(this.logger, "{} : {}", label, message);
    }
}

