
package de.flapdoodle.embed.process.types;

import java.io.File;
import java.util.Objects;

/**
 * Immutable implementation of {@link _ProcessExecutable}.
 * <p>
 * Use the static factory method to create immutable instances:
 * {@code ProcessExecutable.of()}.
 */
@SuppressWarnings({"all"})
public final class ProcessExecutable extends de.flapdoodle.embed.process.types._ProcessExecutable {
  private final File value;

  private ProcessExecutable(File value) {
    this.value = Objects.requireNonNull(value, "value");
  }

  /**
   * @return The value of the {@code value} attribute
   */
  @Override
  public File value() {
    return value;
  }

  /**
   * This instance is equal to all instances of {@code ProcessExecutable} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ProcessExecutable
        && equalsByValue((ProcessExecutable) another);
  }

  private boolean equalsByValue(ProcessExecutable another) {
    return value.equals(another.value);
  }

  /**
   * Computes a hash code from attributes: {@code value}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + value.hashCode();
    return h;
  }

  /**
   * Construct a new immutable {@code ProcessExecutable} instance.
   * @param value The value for the {@code value} attribute
   * @return An immutable ProcessExecutable instance
   */
  public static ProcessExecutable of(File value) {
    return new ProcessExecutable(value);
  }
}
