/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.mongo.transitions;

import de.flapdoodle.embed.mongo.packageresolver.Command;
import de.flapdoodle.embed.mongo.packageresolver.PlatformPackageResolver;
import de.flapdoodle.embed.mongo.transitions.ImmutablePackageOfCommandDistribution;
import de.flapdoodle.embed.mongo.types.DistributionBaseUrl;
import de.flapdoodle.embed.process.config.store.FileSet;
import de.flapdoodle.embed.process.config.store.Package;
import de.flapdoodle.embed.process.distribution.ArchiveType;
import de.flapdoodle.embed.process.distribution.Distribution;
import de.flapdoodle.embed.process.distribution.PackageResolver;
import de.flapdoodle.reverse.State;
import de.flapdoodle.reverse.StateID;
import de.flapdoodle.reverse.StateLookup;
import de.flapdoodle.reverse.TearDown;
import de.flapdoodle.reverse.Transition;
import de.flapdoodle.reverse.naming.HasLabel;
import java.util.Set;
import java.util.function.Function;
import org.immutables.value.Value;

@Value.Immutable
public abstract class PackageOfCommandDistribution
implements Transition<Package>,
HasLabel {
    public String transitionLabel() {
        return "Package of Command-Distribution";
    }

    @Value.Default
    protected Function<Command, PackageResolver> legacyPackageResolverFactory() {
        return PlatformPackageResolver::new;
    }

    @Value.Auxiliary
    protected Package packageOf(Command command, Distribution distribution, DistributionBaseUrl baseUrl) {
        Package relativePackage = this.legacyPackageResolverFactory().apply(command).packageFor(distribution);
        return Package.of((ArchiveType)relativePackage.archiveType(), (FileSet)relativePackage.fileSet(), (String)(baseUrl.value() + relativePackage.url()));
    }

    @Value.Default
    public StateID<Command> command() {
        return StateID.of(Command.class);
    }

    @Value.Default
    public StateID<Distribution> distribution() {
        return StateID.of(Distribution.class);
    }

    @Value.Default
    public StateID<DistributionBaseUrl> distributionBaseUrl() {
        return StateID.of(DistributionBaseUrl.class);
    }

    @Value.Default
    public StateID<Package> destination() {
        return StateID.of(Package.class);
    }

    public Set<StateID<?>> sources() {
        return StateID.setOf((StateID[])new StateID[]{this.command(), this.distribution(), this.distributionBaseUrl()});
    }

    public State<Package> result(StateLookup lookup) {
        Command command = (Command)lookup.of(this.command());
        Distribution distribution = (Distribution)lookup.of(this.distribution());
        DistributionBaseUrl baseUrl = (DistributionBaseUrl)((Object)lookup.of(this.distributionBaseUrl()));
        return State.of((Object)this.packageOf(command, distribution, baseUrl), (TearDown[])new TearDown[0]);
    }

    public static ImmutablePackageOfCommandDistribution.Builder builder() {
        return ImmutablePackageOfCommandDistribution.builder();
    }

    public static ImmutablePackageOfCommandDistribution withDefaults() {
        return PackageOfCommandDistribution.builder().build();
    }
}

