/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.mongo.transitions;

import de.flapdoodle.embed.mongo.commands.MongodArguments;
import de.flapdoodle.embed.mongo.config.Net;
import de.flapdoodle.embed.mongo.transitions.MongodProcessArguments;
import de.flapdoodle.embed.mongo.types.DatabaseDir;
import de.flapdoodle.embed.process.distribution.Version;
import de.flapdoodle.embed.process.types.ProcessArguments;
import de.flapdoodle.os.Platform;
import de.flapdoodle.reverse.StateID;
import java.util.ArrayList;
import java.util.Objects;
import org.immutables.value.Generated;

@Generated(from="MongodProcessArguments", generator="Immutables")
public final class ImmutableMongodProcessArguments
extends MongodProcessArguments {
    private final StateID<ProcessArguments> destination;
    private final StateID<MongodArguments> arguments;
    private final StateID<Platform> platform;
    private final StateID<Version> version;
    private final StateID<Net> net;
    private final StateID<DatabaseDir> databaseDir;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableMongodProcessArguments(Builder builder) {
        if (builder.destination != null) {
            this.initShim.destination((StateID<ProcessArguments>)builder.destination);
        }
        if (builder.arguments != null) {
            this.initShim.arguments((StateID<MongodArguments>)builder.arguments);
        }
        if (builder.platform != null) {
            this.initShim.platform((StateID<Platform>)builder.platform);
        }
        if (builder.version != null) {
            this.initShim.version((StateID<Version>)builder.version);
        }
        if (builder.net != null) {
            this.initShim.net((StateID<Net>)builder.net);
        }
        if (builder.databaseDir != null) {
            this.initShim.databaseDir((StateID<DatabaseDir>)builder.databaseDir);
        }
        this.destination = this.initShim.destination();
        this.arguments = this.initShim.arguments();
        this.platform = this.initShim.platform();
        this.version = this.initShim.version();
        this.net = this.initShim.net();
        this.databaseDir = this.initShim.databaseDir();
        this.initShim = null;
    }

    private ImmutableMongodProcessArguments(StateID<ProcessArguments> destination, StateID<MongodArguments> arguments, StateID<Platform> platform, StateID<Version> version, StateID<Net> net, StateID<DatabaseDir> databaseDir) {
        this.destination = destination;
        this.arguments = arguments;
        this.platform = platform;
        this.version = version;
        this.net = net;
        this.databaseDir = databaseDir;
        this.initShim = null;
    }

    @Override
    public StateID<ProcessArguments> destination() {
        InitShim shim = this.initShim;
        return shim != null ? shim.destination() : this.destination;
    }

    @Override
    public StateID<MongodArguments> arguments() {
        InitShim shim = this.initShim;
        return shim != null ? shim.arguments() : this.arguments;
    }

    @Override
    public StateID<Platform> platform() {
        InitShim shim = this.initShim;
        return shim != null ? shim.platform() : this.platform;
    }

    @Override
    public StateID<Version> version() {
        InitShim shim = this.initShim;
        return shim != null ? shim.version() : this.version;
    }

    @Override
    public StateID<Net> net() {
        InitShim shim = this.initShim;
        return shim != null ? shim.net() : this.net;
    }

    @Override
    public StateID<DatabaseDir> databaseDir() {
        InitShim shim = this.initShim;
        return shim != null ? shim.databaseDir() : this.databaseDir;
    }

    public final ImmutableMongodProcessArguments withDestination(StateID<ProcessArguments> value) {
        if (this.destination == value) {
            return this;
        }
        StateID<ProcessArguments> newValue = Objects.requireNonNull(value, "destination");
        return new ImmutableMongodProcessArguments(newValue, this.arguments, this.platform, this.version, this.net, this.databaseDir);
    }

    public final ImmutableMongodProcessArguments withArguments(StateID<MongodArguments> value) {
        if (this.arguments == value) {
            return this;
        }
        StateID<MongodArguments> newValue = Objects.requireNonNull(value, "arguments");
        return new ImmutableMongodProcessArguments(this.destination, newValue, this.platform, this.version, this.net, this.databaseDir);
    }

    public final ImmutableMongodProcessArguments withPlatform(StateID<Platform> value) {
        if (this.platform == value) {
            return this;
        }
        StateID<Platform> newValue = Objects.requireNonNull(value, "platform");
        return new ImmutableMongodProcessArguments(this.destination, this.arguments, newValue, this.version, this.net, this.databaseDir);
    }

    public final ImmutableMongodProcessArguments withVersion(StateID<Version> value) {
        if (this.version == value) {
            return this;
        }
        StateID<Version> newValue = Objects.requireNonNull(value, "version");
        return new ImmutableMongodProcessArguments(this.destination, this.arguments, this.platform, newValue, this.net, this.databaseDir);
    }

    public final ImmutableMongodProcessArguments withNet(StateID<Net> value) {
        if (this.net == value) {
            return this;
        }
        StateID<Net> newValue = Objects.requireNonNull(value, "net");
        return new ImmutableMongodProcessArguments(this.destination, this.arguments, this.platform, this.version, newValue, this.databaseDir);
    }

    public final ImmutableMongodProcessArguments withDatabaseDir(StateID<DatabaseDir> value) {
        if (this.databaseDir == value) {
            return this;
        }
        StateID<DatabaseDir> newValue = Objects.requireNonNull(value, "databaseDir");
        return new ImmutableMongodProcessArguments(this.destination, this.arguments, this.platform, this.version, this.net, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMongodProcessArguments && this.equalTo(0, (ImmutableMongodProcessArguments)another);
    }

    private boolean equalTo(int synthetic, ImmutableMongodProcessArguments another) {
        return this.destination.equals(another.destination) && this.arguments.equals(another.arguments) && this.platform.equals(another.platform) && this.version.equals(another.version) && this.net.equals(another.net) && this.databaseDir.equals(another.databaseDir);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.destination.hashCode();
        h += (h << 5) + this.arguments.hashCode();
        h += (h << 5) + this.platform.hashCode();
        h += (h << 5) + this.version.hashCode();
        h += (h << 5) + this.net.hashCode();
        h += (h << 5) + this.databaseDir.hashCode();
        return h;
    }

    public String toString() {
        return "MongodProcessArguments{destination=" + this.destination + ", arguments=" + this.arguments + ", platform=" + this.platform + ", version=" + this.version + ", net=" + this.net + ", databaseDir=" + this.databaseDir + "}";
    }

    public static ImmutableMongodProcessArguments copyOf(MongodProcessArguments instance) {
        if (instance instanceof ImmutableMongodProcessArguments) {
            return (ImmutableMongodProcessArguments)instance;
        }
        return ImmutableMongodProcessArguments.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="MongodProcessArguments", generator="Immutables")
    public static final class Builder {
        private StateID<ProcessArguments> destination;
        private StateID<MongodArguments> arguments;
        private StateID<Platform> platform;
        private StateID<Version> version;
        private StateID<Net> net;
        private StateID<DatabaseDir> databaseDir;

        private Builder() {
        }

        public final Builder from(MongodProcessArguments instance) {
            Objects.requireNonNull(instance, "instance");
            this.destination(instance.destination());
            this.arguments(instance.arguments());
            this.platform(instance.platform());
            this.version(instance.version());
            this.net(instance.net());
            this.databaseDir(instance.databaseDir());
            return this;
        }

        public final Builder destination(StateID<ProcessArguments> destination) {
            this.destination = Objects.requireNonNull(destination, "destination");
            return this;
        }

        public final Builder arguments(StateID<MongodArguments> arguments) {
            this.arguments = Objects.requireNonNull(arguments, "arguments");
            return this;
        }

        public final Builder platform(StateID<Platform> platform) {
            this.platform = Objects.requireNonNull(platform, "platform");
            return this;
        }

        public final Builder version(StateID<Version> version) {
            this.version = Objects.requireNonNull(version, "version");
            return this;
        }

        public final Builder net(StateID<Net> net) {
            this.net = Objects.requireNonNull(net, "net");
            return this;
        }

        public final Builder databaseDir(StateID<DatabaseDir> databaseDir) {
            this.databaseDir = Objects.requireNonNull(databaseDir, "databaseDir");
            return this;
        }

        public ImmutableMongodProcessArguments build() {
            return new ImmutableMongodProcessArguments(this);
        }
    }

    @Generated(from="MongodProcessArguments", generator="Immutables")
    private final class InitShim {
        private byte destinationBuildStage = 0;
        private StateID<ProcessArguments> destination;
        private byte argumentsBuildStage = 0;
        private StateID<MongodArguments> arguments;
        private byte platformBuildStage = 0;
        private StateID<Platform> platform;
        private byte versionBuildStage = 0;
        private StateID<Version> version;
        private byte netBuildStage = 0;
        private StateID<Net> net;
        private byte databaseDirBuildStage = 0;
        private StateID<DatabaseDir> databaseDir;

        private InitShim() {
        }

        StateID<ProcessArguments> destination() {
            if (this.destinationBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.destinationBuildStage == 0) {
                this.destinationBuildStage = (byte)-1;
                this.destination = Objects.requireNonNull(ImmutableMongodProcessArguments.super.destination(), "destination");
                this.destinationBuildStage = 1;
            }
            return this.destination;
        }

        void destination(StateID<ProcessArguments> destination) {
            this.destination = destination;
            this.destinationBuildStage = 1;
        }

        StateID<MongodArguments> arguments() {
            if (this.argumentsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.argumentsBuildStage == 0) {
                this.argumentsBuildStage = (byte)-1;
                this.arguments = Objects.requireNonNull(ImmutableMongodProcessArguments.super.arguments(), "arguments");
                this.argumentsBuildStage = 1;
            }
            return this.arguments;
        }

        void arguments(StateID<MongodArguments> arguments) {
            this.arguments = arguments;
            this.argumentsBuildStage = 1;
        }

        StateID<Platform> platform() {
            if (this.platformBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.platformBuildStage == 0) {
                this.platformBuildStage = (byte)-1;
                this.platform = Objects.requireNonNull(ImmutableMongodProcessArguments.super.platform(), "platform");
                this.platformBuildStage = 1;
            }
            return this.platform;
        }

        void platform(StateID<Platform> platform) {
            this.platform = platform;
            this.platformBuildStage = 1;
        }

        StateID<Version> version() {
            if (this.versionBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.versionBuildStage == 0) {
                this.versionBuildStage = (byte)-1;
                this.version = Objects.requireNonNull(ImmutableMongodProcessArguments.super.version(), "version");
                this.versionBuildStage = 1;
            }
            return this.version;
        }

        void version(StateID<Version> version) {
            this.version = version;
            this.versionBuildStage = 1;
        }

        StateID<Net> net() {
            if (this.netBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.netBuildStage == 0) {
                this.netBuildStage = (byte)-1;
                this.net = Objects.requireNonNull(ImmutableMongodProcessArguments.super.net(), "net");
                this.netBuildStage = 1;
            }
            return this.net;
        }

        void net(StateID<Net> net) {
            this.net = net;
            this.netBuildStage = 1;
        }

        StateID<DatabaseDir> databaseDir() {
            if (this.databaseDirBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.databaseDirBuildStage == 0) {
                this.databaseDirBuildStage = (byte)-1;
                this.databaseDir = Objects.requireNonNull(ImmutableMongodProcessArguments.super.databaseDir(), "databaseDir");
                this.databaseDirBuildStage = 1;
            }
            return this.databaseDir;
        }

        void databaseDir(StateID<DatabaseDir> databaseDir) {
            this.databaseDir = databaseDir;
            this.databaseDirBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.destinationBuildStage == -1) {
                attributes.add("destination");
            }
            if (this.argumentsBuildStage == -1) {
                attributes.add("arguments");
            }
            if (this.platformBuildStage == -1) {
                attributes.add("platform");
            }
            if (this.versionBuildStage == -1) {
                attributes.add("version");
            }
            if (this.netBuildStage == -1) {
                attributes.add("net");
            }
            if (this.databaseDirBuildStage == -1) {
                attributes.add("databaseDir");
            }
            return "Cannot build MongodProcessArguments, attribute initializers form cycle " + attributes;
        }
    }
}

