/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.mongo.transitions;

import de.flapdoodle.embed.mongo.transitions.ExecutedMongoShellProcess;
import de.flapdoodle.embed.process.types.ExecutedProcess;
import java.util.ArrayList;
import java.util.Objects;

public final class ImmutableExecutedMongoShellProcess
extends ExecutedMongoShellProcess {
    private final int returnCode;

    private ImmutableExecutedMongoShellProcess(int returnCode) {
        this.returnCode = returnCode;
    }

    public int returnCode() {
        return this.returnCode;
    }

    public final ImmutableExecutedMongoShellProcess withReturnCode(int value) {
        if (this.returnCode == value) {
            return this;
        }
        return new ImmutableExecutedMongoShellProcess(value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableExecutedMongoShellProcess && this.equalsByValue((ImmutableExecutedMongoShellProcess)another);
    }

    private boolean equalsByValue(ImmutableExecutedMongoShellProcess another) {
        return this.returnCode == another.returnCode;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.returnCode;
        return h;
    }

    public String toString() {
        return "ExecutedMongoShellProcess{returnCode=" + this.returnCode + "}";
    }

    public static ImmutableExecutedMongoShellProcess copyOf(ExecutedMongoShellProcess instance) {
        if (instance instanceof ImmutableExecutedMongoShellProcess) {
            return (ImmutableExecutedMongoShellProcess)instance;
        }
        return ImmutableExecutedMongoShellProcess.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_RETURN_CODE = 1L;
        private long initBits = 1L;
        private int returnCode;

        private Builder() {
        }

        public final Builder from(ExecutedProcess instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeInternal(instance);
            return this;
        }

        public final Builder from(ExecutedMongoShellProcess instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeInternal(instance);
            return this;
        }

        private void mergeInternal(Object object) {
            if (object instanceof ExecutedProcess) {
                ExecutedProcess instance = (ExecutedProcess)object;
                this.returnCode(instance.returnCode());
            }
        }

        public final Builder returnCode(int returnCode) {
            this.returnCode = returnCode;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableExecutedMongoShellProcess build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableExecutedMongoShellProcess(this.returnCode);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("returnCode");
            }
            return "Cannot build ExecutedMongoShellProcess, some of required attributes are not set " + attributes;
        }
    }
}

