/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.mongo.client;

import com.mongodb.ConnectionString;
import com.mongodb.MongoClientSettings;
import com.mongodb.MongoCredential;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import de.flapdoodle.embed.mongo.client.ExecuteMongoClientAction;
import de.flapdoodle.embed.mongo.client.MongoClientAction;
import de.flapdoodle.embed.mongo.commands.ServerAddress;
import org.bson.Document;
import org.bson.conversions.Bson;

public class SyncClientAdapter
extends ExecuteMongoClientAction<MongoClient> {
    private final MongoClientSettings clientSettings;

    public SyncClientAdapter(MongoClientSettings clientSettings) {
        this.clientSettings = clientSettings;
    }

    @Override
    protected MongoClient client(ServerAddress serverAddress) {
        return MongoClients.create((MongoClientSettings)MongoClientSettings.builder((MongoClientSettings)this.clientSettings).applyConnectionString(new ConnectionString("mongodb://" + serverAddress)).build());
    }

    @Override
    protected MongoClient client(ServerAddress serverAddress, MongoCredential credential) {
        return MongoClients.create((MongoClientSettings)MongoClientSettings.builder((MongoClientSettings)this.clientSettings).applyConnectionString(new ConnectionString("mongodb://" + serverAddress)).credential(credential).build());
    }

    @Override
    protected Document resultOfAction(MongoClient client, MongoClientAction.Action action) {
        if (action instanceof MongoClientAction.RunCommand) {
            return client.getDatabase(action.database()).runCommand((Bson)((MongoClientAction.RunCommand)action).command());
        }
        throw new IllegalArgumentException("Action not supported: " + action);
    }
}

