/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.mongo;

import de.flapdoodle.embed.mongo.AbstractMongoProcess;
import de.flapdoodle.embed.mongo.MongodExecutable;
import de.flapdoodle.embed.mongo.config.MongodConfig;
import de.flapdoodle.embed.mongo.runtime.Mongod;
import de.flapdoodle.embed.process.config.ExecutableProcessConfig;
import de.flapdoodle.embed.process.config.RuntimeConfig;
import de.flapdoodle.embed.process.distribution.Distribution;
import de.flapdoodle.embed.process.extract.ExtractedFileSet;
import de.flapdoodle.embed.process.io.directories.Directory;
import de.flapdoodle.embed.process.io.directories.PropertyOrPlatformTempDir;
import de.flapdoodle.embed.process.io.file.Files;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongodProcess
extends AbstractMongoProcess<MongodConfig, MongodExecutable, MongodProcess> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MongodProcess.class);
    private File dbDir;
    private boolean dbDirIsTemp;

    public MongodProcess(Distribution distribution, MongodConfig config, RuntimeConfig runtimeConfig, MongodExecutable mongodExecutable) throws IOException {
        super(distribution, config, runtimeConfig, mongodExecutable);
    }

    protected void onBeforeProcess(RuntimeConfig runtimeConfig) {
        super.onBeforeProcess(runtimeConfig);
        try {
            File tmpDbDir;
            MongodConfig config = (MongodConfig)this.getConfig();
            if (config.replication().getDatabaseDir() != null) {
                tmpDbDir = Files.createOrCheckDir((String)config.replication().getDatabaseDir());
            } else {
                tmpDbDir = Files.createTempDir((Directory)PropertyOrPlatformTempDir.defaultInstance(), (String)"embedmongo-db");
                this.dbDirIsTemp = true;
            }
            this.dbDir = tmpDbDir;
        }
        catch (IOException iox) {
            throw new RuntimeException(iox);
        }
    }

    protected void onBeforeProcessStart(ProcessBuilder processBuilder, MongodConfig config, RuntimeConfig runtimeConfig) {
        config.processListener().onBeforeProcessStart(this.dbDir, this.dbDirIsTemp);
        super.onBeforeProcessStart(processBuilder, (ExecutableProcessConfig)config, runtimeConfig);
    }

    protected void onAfterProcessStop(MongodConfig config, RuntimeConfig runtimeConfig) {
        super.onAfterProcessStop((ExecutableProcessConfig)config, runtimeConfig);
        config.processListener().onAfterProcessStop(this.dbDir, this.dbDirIsTemp);
    }

    protected List<String> getCommandLine(Distribution distribution, MongodConfig config, ExtractedFileSet files) throws IOException {
        return Mongod.enhanceCommandLinePlattformSpecific(distribution, Mongod.getCommandLine((MongodConfig)this.getConfig(), files, this.dbDir));
    }

    @Override
    protected void deleteTempFiles() {
        super.deleteTempFiles();
        if (this.dbDir != null && this.dbDirIsTemp && !Files.forceDelete((File)this.dbDir)) {
            LOGGER.warn("Could not delete temp db dir: {}", (Object)this.dbDir);
        }
    }
}

