/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.mongo.runtime;

import de.flapdoodle.embed.mongo.config.MongoRestoreConfig;
import de.flapdoodle.embed.mongo.config.Net;
import de.flapdoodle.embed.mongo.runtime.AbstractMongo;
import de.flapdoodle.embed.process.extract.ExtractedFileSet;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class MongoRestore
extends AbstractMongo {
    public static List<String> getCommandLine(MongoRestoreConfig config, ExtractedFileSet files) throws UnknownHostException {
        ArrayList<String> ret = new ArrayList<String>(Collections.singletonList(files.executable().getAbsolutePath()));
        if (config.isVerbose()) {
            ret.add("-v");
        }
        MongoRestore.applyNet(config.net(), ret);
        if (config.getDatabaseName().isPresent()) {
            ret.add("--db");
            ret.add(config.getDatabaseName().get());
        }
        if (config.getCollectionName().isPresent()) {
            ret.add("--collection");
            ret.add(config.getCollectionName().get());
        }
        if (config.isObjectCheck()) {
            ret.add("--objCheck");
        }
        if (config.isOplogReplay()) {
            ret.add("--oplogReplay");
        }
        if (config.getOplogLimit().isPresent()) {
            ret.add("--oplogLimit");
            ret.add("" + config.getOplogLimit().getAsLong());
        }
        if (config.getArchive().isPresent()) {
            ret.add(String.format("--archive=%s", config.getArchive().get()));
        }
        if (config.isRestoreDbUsersAndRoles()) {
            ret.add("--restoreDbUsersAndRoles");
        }
        if (config.getDir().isPresent()) {
            ret.add("--dir");
            ret.add(config.getDir().get());
        }
        if (config.isGzip()) {
            ret.add("--gzip");
        }
        if (config.isDropCollection()) {
            ret.add("--drop");
        }
        if (config.getWriteConcern().isPresent()) {
            ret.add("--writeConcern");
            ret.add(config.getWriteConcern().get());
        }
        if (config.isNoIndexRestore()) {
            ret.add("--noIndexRestore");
        }
        if (config.isNoOptionsRestore()) {
            ret.add("--noOptionsRestore");
        }
        if (config.isKeepIndexVersion()) {
            ret.add("--keepIndexVersion");
        }
        if (config.isMaintainInsertionOrder()) {
            ret.add("--maintainInsertionOrder");
        }
        if (config.getNumberOfParallelCollections().isPresent()) {
            ret.add("--numParallelCollections");
            ret.add("" + config.getNumberOfParallelCollections().getAsInt());
        }
        if (config.getNumberOfInsertionWorkersPerCollection().isPresent()) {
            ret.add("--numInsertionWorkersPerCollection");
            ret.add("" + config.getNumberOfInsertionWorkersPerCollection().getAsInt());
        }
        if (config.isStopOnError()) {
            ret.add("--stopOnError");
        }
        if (config.isBypassDocumentValidation()) {
            ret.add("--bypassDocumentValidation");
        }
        return ret;
    }

    protected static void applyNet(Net net, List<String> ret) {
        ret.add("--port");
        ret.add("" + net.getPort());
        if (net.getBindIp() != null) {
            ret.add("--host");
            ret.add(net.getBindIp());
        }
    }
}

