/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.mongo.runtime;

import de.flapdoodle.embed.mongo.config.MongoDumpConfig;
import de.flapdoodle.embed.mongo.config.Net;
import de.flapdoodle.embed.mongo.runtime.AbstractMongo;
import de.flapdoodle.embed.process.extract.ExtractedFileSet;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class MongoDump
extends AbstractMongo {
    public static List<String> getCommandLine(MongoDumpConfig config, ExtractedFileSet files) throws UnknownHostException {
        ArrayList<String> ret = new ArrayList<String>(Collections.singletonList(files.executable().getAbsolutePath()));
        if (config.isVerbose()) {
            ret.add("-v");
        }
        MongoDump.applyNet(config.net(), ret);
        if (config.getDatabaseName().isPresent()) {
            ret.add("--db");
            ret.add(config.getDatabaseName().get());
        }
        if (config.getCollectionName().isPresent()) {
            ret.add("--collection");
            ret.add(config.getCollectionName().get());
        }
        if (config.getQuery().isPresent()) {
            ret.add("--query");
            ret.add(config.getQuery().get());
        }
        if (config.getQueryFile().isPresent()) {
            ret.add("--queryFile");
            ret.add(config.getQueryFile().get());
        }
        if (config.getReadPreference().isPresent()) {
            ret.add("--readPreference");
            ret.add(config.getReadPreference().get());
        }
        if (config.isForceTableScan()) {
            ret.add("--forceTableScan");
        }
        if (config.getArchive().isPresent()) {
            ret.add("--archive=" + config.getArchive().get());
        }
        if (config.isDumpDbUsersAndRoles()) {
            ret.add("--dumpDbUsersAndRoles");
        }
        if (config.getOut().isPresent()) {
            ret.add("--out");
            ret.add(config.getOut().get());
        }
        if (config.isGzip()) {
            ret.add("--gzip");
        }
        if (config.isRepair()) {
            ret.add("--repair");
        }
        if (config.isOplog()) {
            ret.add("--oplog");
        }
        if (config.getExcludeCollection().isPresent()) {
            ret.add("--excludeCollection");
            ret.add(config.getExcludeCollection().get());
        }
        if (config.getExcludeCollectionWithPrefix().isPresent()) {
            ret.add("--excludeCollectionWithPrefix");
            ret.add(config.getExcludeCollectionWithPrefix().get());
        }
        if (config.getNumberOfParallelCollections().isPresent()) {
            ret.add("--numParallelCollections");
            ret.add("" + config.getNumberOfParallelCollections().getAsInt());
        }
        return ret;
    }

    protected static void applyNet(Net net, List<String> ret) {
        ret.add("--port");
        ret.add("" + net.getPort());
        if (net.getBindIp() != null) {
            ret.add("--host");
            ret.add(net.getBindIp());
        }
    }
}

