/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.mongo.packageresolver;

import de.flapdoodle.embed.mongo.Command;
import de.flapdoodle.embed.mongo.packageresolver.DistributionMatch;
import de.flapdoodle.embed.mongo.packageresolver.ImmutablePlatformMatchRule;
import de.flapdoodle.embed.mongo.packageresolver.ImmutablePlatformMatchRules;
import de.flapdoodle.embed.mongo.packageresolver.PackageFinder;
import de.flapdoodle.embed.mongo.packageresolver.PlatformMatch;
import de.flapdoodle.embed.mongo.packageresolver.PlatformMatchRule;
import de.flapdoodle.embed.mongo.packageresolver.PlatformMatchRules;
import de.flapdoodle.embed.mongo.packageresolver.UrlTemplatePackageResolver;
import de.flapdoodle.embed.mongo.packageresolver.VersionRange;
import de.flapdoodle.embed.process.config.store.DistributionPackage;
import de.flapdoodle.embed.process.config.store.FileSet;
import de.flapdoodle.embed.process.config.store.FileType;
import de.flapdoodle.embed.process.distribution.ArchiveType;
import de.flapdoodle.embed.process.distribution.Distribution;
import de.flapdoodle.os.BitSize;
import de.flapdoodle.os.OS;
import java.util.Optional;

public class OSXPackageFinder
implements PackageFinder {
    private final Command command;
    private final ImmutablePlatformMatchRules rules;

    public OSXPackageFinder(Command command) {
        this.command = command;
        this.rules = OSXPackageFinder.rules(command);
    }

    @Override
    public Optional<DistributionPackage> packageFor(Distribution distribution) {
        return this.rules.packageFor(distribution);
    }

    private static FileSet fileSetOf(Command command) {
        return FileSet.builder().addEntry(FileType.Executable, command.commandName()).build();
    }

    private static ImmutablePlatformMatchRules rules(Command command) {
        FileSet fileSet = OSXPackageFinder.fileSetOf(command);
        ArchiveType archiveType = ArchiveType.TGZ;
        ImmutablePlatformMatchRule firstRule = PlatformMatchRule.builder().match(DistributionMatch.any(VersionRange.of("4.0.0", "4.0.26"), VersionRange.of("3.6.0", "3.6.22")).andThen(PlatformMatch.withOs(OS.OS_X).withBitSize(BitSize.B64))).finder(UrlTemplatePackageResolver.builder().fileSet(fileSet).archiveType(archiveType).urlTemplate("/osx/mongodb-osx-ssl-x86_64-{version}.tgz").build()).build();
        ImmutablePlatformMatchRule secondRule = PlatformMatchRule.builder().match(DistributionMatch.any(VersionRange.of("3.4.9", "3.4.23"), VersionRange.of("3.4.0", "3.4.7"), VersionRange.of("3.2.0", "3.2.21"), VersionRange.of("3.0.4", "3.0.14")).andThen(PlatformMatch.withOs(OS.OS_X).withBitSize(BitSize.B64))).finder(UrlTemplatePackageResolver.builder().fileSet(fileSet).archiveType(archiveType).urlTemplate("/osx/mongodb-osx-ssl-x86_64-{version}.tgz").build()).build();
        ImmutablePlatformMatchRule thirdRule = PlatformMatchRule.builder().match(DistributionMatch.any(VersionRange.of("3.0.0", "3.0.3"), VersionRange.of("2.6.0", "2.6.12")).andThen(PlatformMatch.withOs(OS.OS_X).withBitSize(BitSize.B64))).finder(UrlTemplatePackageResolver.builder().fileSet(fileSet).archiveType(archiveType).urlTemplate("/osx/mongodb-osx-x86_64-{version}.tgz").build()).build();
        ImmutablePlatformMatchRule hiddenLegacyRule = PlatformMatchRule.builder().match(DistributionMatch.any(VersionRange.of("3.3.1", "3.3.1"), VersionRange.of("3.5.5", "3.5.5")).andThen(PlatformMatch.withOs(OS.OS_X).withBitSize(BitSize.B64))).finder(UrlTemplatePackageResolver.builder().fileSet(fileSet).archiveType(archiveType).urlTemplate("/osx/mongodb-osx-x86_64-{version}.tgz").build()).build();
        ImmutablePlatformMatchRule fourthRule = PlatformMatchRule.builder().match(DistributionMatch.any(VersionRange.of("5.0.0", "5.0.2"), VersionRange.of("4.4.0", "4.4.9"), VersionRange.of("4.2.5", "4.2.16"), VersionRange.of("4.2.0", "4.2.3")).andThen(PlatformMatch.withOs(OS.OS_X).withBitSize(BitSize.B64))).finder(UrlTemplatePackageResolver.builder().fileSet(fileSet).archiveType(archiveType).urlTemplate("/osx/mongodb-macos-x86_64-{version}.tgz").build()).build();
        ImmutablePlatformMatchRule toolsRule = PlatformMatchRule.builder().match(DistributionMatch.any(VersionRange.of("5.0.0", "5.0.2"), VersionRange.of("4.4.0", "4.4.9")).andThen(PlatformMatch.withOs(OS.OS_X).withBitSize(BitSize.B64))).finder(UrlTemplatePackageResolver.builder().fileSet(fileSet).archiveType(archiveType).urlTemplate("/tools/db/mongodb-database-tools-macos-x86_64-{tools.version}.zip").build()).build();
        ImmutablePlatformMatchRule failIfNothingMatches = PlatformMatchRule.builder().match(PlatformMatch.withOs(OS.OS_X)).finder(distribution -> {
            throw new IllegalArgumentException("osx distribution not supported: " + distribution);
        }).build();
        switch (command) {
            case MongoDump: 
            case MongoImport: 
            case MongoRestore: {
                return PlatformMatchRules.empty().withRules(toolsRule, firstRule, secondRule, thirdRule, fourthRule, hiddenLegacyRule, failIfNothingMatches);
            }
        }
        return PlatformMatchRules.empty().withRules(firstRule, secondRule, thirdRule, fourthRule, hiddenLegacyRule, failIfNothingMatches);
    }
}

