/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.mongo.spring.autoconfigure;

import de.flapdoodle.embed.mongo.spring.autoconfigure.MongoClientAction;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import org.bson.Document;
import org.immutables.value.Generated;

@Generated(from="MongoClientAction", generator="Immutables")
final class ImmutableMongoClientAction
extends MongoClientAction {
    private final MongoClientAction.Credentials credentials;
    private final MongoClientAction.Action action;
    private final Consumer<Document> onResult;
    private final Consumer<RuntimeException> onError;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableMongoClientAction(Builder builder) {
        this.credentials = builder.credentials;
        this.action = builder.action;
        if (builder.onResult != null) {
            this.initShim.onResult(builder.onResult);
        }
        if (builder.onError != null) {
            this.initShim.onError(builder.onError);
        }
        this.onResult = this.initShim.onResult();
        this.onError = this.initShim.onError();
        this.initShim = null;
    }

    private ImmutableMongoClientAction(MongoClientAction.Credentials credentials, MongoClientAction.Action action, Consumer<Document> onResult, Consumer<RuntimeException> onError) {
        this.credentials = credentials;
        this.action = action;
        this.onResult = onResult;
        this.onError = onError;
        this.initShim = null;
    }

    @Override
    public Optional<MongoClientAction.Credentials> credentials() {
        return Optional.ofNullable(this.credentials);
    }

    @Override
    public MongoClientAction.Action action() {
        return this.action;
    }

    @Override
    public Consumer<Document> onResult() {
        InitShim shim = this.initShim;
        return shim != null ? shim.onResult() : this.onResult;
    }

    @Override
    public Consumer<RuntimeException> onError() {
        InitShim shim = this.initShim;
        return shim != null ? shim.onError() : this.onError;
    }

    public final ImmutableMongoClientAction withCredentials(MongoClientAction.Credentials value) {
        MongoClientAction.Credentials newValue = Objects.requireNonNull(value, "credentials");
        if (this.credentials == newValue) {
            return this;
        }
        return new ImmutableMongoClientAction(newValue, this.action, this.onResult, this.onError);
    }

    public final ImmutableMongoClientAction withCredentials(Optional<? extends MongoClientAction.Credentials> optional) {
        MongoClientAction.Credentials value = optional.orElse(null);
        if (this.credentials == value) {
            return this;
        }
        return new ImmutableMongoClientAction(value, this.action, this.onResult, this.onError);
    }

    public final ImmutableMongoClientAction withAction(MongoClientAction.Action value) {
        if (this.action == value) {
            return this;
        }
        MongoClientAction.Action newValue = Objects.requireNonNull(value, "action");
        return new ImmutableMongoClientAction(this.credentials, newValue, this.onResult, this.onError);
    }

    public final ImmutableMongoClientAction withOnResult(Consumer<Document> value) {
        if (this.onResult == value) {
            return this;
        }
        Consumer<Document> newValue = Objects.requireNonNull(value, "onResult");
        return new ImmutableMongoClientAction(this.credentials, this.action, newValue, this.onError);
    }

    public final ImmutableMongoClientAction withOnError(Consumer<RuntimeException> value) {
        if (this.onError == value) {
            return this;
        }
        Consumer<RuntimeException> newValue = Objects.requireNonNull(value, "onError");
        return new ImmutableMongoClientAction(this.credentials, this.action, this.onResult, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMongoClientAction && this.equalTo(0, (ImmutableMongoClientAction)another);
    }

    private boolean equalTo(int synthetic, ImmutableMongoClientAction another) {
        return Objects.equals(this.credentials, another.credentials) && this.action.equals(another.action) && this.onResult.equals(another.onResult) && this.onError.equals(another.onError);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.credentials);
        h += (h << 5) + this.action.hashCode();
        h += (h << 5) + this.onResult.hashCode();
        h += (h << 5) + this.onError.hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("MongoClientAction{");
        if (this.credentials != null) {
            builder.append("credentials=").append(this.credentials);
        }
        if (builder.length() > 18) {
            builder.append(", ");
        }
        builder.append("action=").append(this.action);
        builder.append(", ");
        builder.append("onResult=").append(this.onResult);
        builder.append(", ");
        builder.append("onError=").append(this.onError);
        return builder.append("}").toString();
    }

    public static ImmutableMongoClientAction copyOf(MongoClientAction instance) {
        if (instance instanceof ImmutableMongoClientAction) {
            return (ImmutableMongoClientAction)instance;
        }
        return ImmutableMongoClientAction.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="MongoClientAction", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_ACTION = 1L;
        private long initBits = 1L;
        private MongoClientAction.Credentials credentials;
        private MongoClientAction.Action action;
        private Consumer<Document> onResult;
        private Consumer<RuntimeException> onError;

        private Builder() {
        }

        public final Builder from(MongoClientAction instance) {
            Objects.requireNonNull(instance, "instance");
            Optional<MongoClientAction.Credentials> credentialsOptional = instance.credentials();
            if (credentialsOptional.isPresent()) {
                this.credentials(credentialsOptional);
            }
            this.action(instance.action());
            this.onResult(instance.onResult());
            this.onError(instance.onError());
            return this;
        }

        public final Builder credentials(MongoClientAction.Credentials credentials) {
            this.credentials = Objects.requireNonNull(credentials, "credentials");
            return this;
        }

        public final Builder credentials(Optional<? extends MongoClientAction.Credentials> credentials) {
            this.credentials = credentials.orElse(null);
            return this;
        }

        public final Builder action(MongoClientAction.Action action) {
            this.action = Objects.requireNonNull(action, "action");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder onResult(Consumer<Document> onResult) {
            this.onResult = Objects.requireNonNull(onResult, "onResult");
            return this;
        }

        public final Builder onError(Consumer<RuntimeException> onError) {
            this.onError = Objects.requireNonNull(onError, "onError");
            return this;
        }

        public ImmutableMongoClientAction build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableMongoClientAction(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("action");
            }
            return "Cannot build MongoClientAction, some of required attributes are not set " + attributes;
        }
    }

    @Generated(from="MongoClientAction", generator="Immutables")
    private final class InitShim {
        private byte onResultBuildStage = 0;
        private Consumer<Document> onResult;
        private byte onErrorBuildStage = 0;
        private Consumer<RuntimeException> onError;

        private InitShim() {
        }

        Consumer<Document> onResult() {
            if (this.onResultBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.onResultBuildStage == 0) {
                this.onResultBuildStage = (byte)-1;
                this.onResult = Objects.requireNonNull(ImmutableMongoClientAction.super.onResult(), "onResult");
                this.onResultBuildStage = 1;
            }
            return this.onResult;
        }

        void onResult(Consumer<Document> onResult) {
            this.onResult = onResult;
            this.onResultBuildStage = 1;
        }

        Consumer<RuntimeException> onError() {
            if (this.onErrorBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.onErrorBuildStage == 0) {
                this.onErrorBuildStage = (byte)-1;
                this.onError = Objects.requireNonNull(ImmutableMongoClientAction.super.onError(), "onError");
                this.onErrorBuildStage = 1;
            }
            return this.onError;
        }

        void onError(Consumer<RuntimeException> onError) {
            this.onError = onError;
            this.onErrorBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.onResultBuildStage == -1) {
                attributes.add("onResult");
            }
            if (this.onErrorBuildStage == -1) {
                attributes.add("onError");
            }
            return "Cannot build MongoClientAction, attribute initializers form cycle " + attributes;
        }
    }
}

