/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.mongo.spring.autoconfigure;

import com.mongodb.MongoCredential;
import de.flapdoodle.embed.mongo.commands.MongodArguments;
import de.flapdoodle.embed.mongo.commands.ServerAddress;
import de.flapdoodle.embed.mongo.config.Storage;
import de.flapdoodle.embed.mongo.distribution.IFeatureAwareVersion;
import de.flapdoodle.embed.mongo.packageresolver.Feature;
import de.flapdoodle.embed.mongo.spring.autoconfigure.ImmutableMongoClientAction;
import de.flapdoodle.embed.mongo.spring.autoconfigure.MongoClientAction;
import de.flapdoodle.embed.mongo.spring.autoconfigure.MongodWrapper;
import de.flapdoodle.embed.mongo.transitions.Mongod;
import de.flapdoodle.embed.mongo.transitions.RunningMongoProcess;
import de.flapdoodle.embed.mongo.transitions.RunningMongodProcess;
import de.flapdoodle.embed.process.distribution.Version;
import de.flapdoodle.reverse.Listener;
import de.flapdoodle.reverse.StateID;
import de.flapdoodle.types.Try;
import java.io.Closeable;
import java.io.IOException;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.bson.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.mongo.MongoProperties;

public abstract class AbstractServerFactory<C extends Closeable> {
    private static Logger logger = LoggerFactory.getLogger(AbstractServerFactory.class);
    protected final MongoProperties properties;

    protected AbstractServerFactory(MongoProperties properties) {
        this.properties = properties;
    }

    public final MongodWrapper createWrapper(IFeatureAwareVersion version, Mongod mongod, MongodArguments mongodArguments) {
        return new MongodWrapper(mongod.transitions((Version)version), this.addAuthUserToDB(this.properties), this.initReplicaSet(version, this.properties, mongodArguments));
    }

    private Listener addAuthUserToDB(MongoProperties properties) {
        Listener.TypedListener.Builder typedBuilder = Listener.typedBuilder();
        String username = properties.getUsername();
        char[] password = properties.getPassword();
        String databaseName = properties.getMongoClientDatabase();
        if (username != null && password != null) {
            typedBuilder.onStateReached(StateID.of(RunningMongodProcess.class), this.executeClientActions(AbstractServerFactory.createAdminUserWithDatabaseAccess(username, password, databaseName)));
            typedBuilder.onStateTearDown(StateID.of(RunningMongodProcess.class), this.executeClientActions(Collections.singletonList(AbstractServerFactory.shutdown(username, password))).andThen(RunningMongoProcess::shutDownCommandAlreadyExecuted));
        }
        return typedBuilder.build();
    }

    private Listener initReplicaSet(IFeatureAwareVersion version, MongoProperties properties, MongodArguments mongodArguments) {
        Optional credentials;
        Listener.TypedListener.Builder builder = Listener.typedBuilder();
        String username = properties.getUsername();
        char[] password = properties.getPassword();
        Optional replication = mongodArguments.replication();
        Optional<Object> optional = credentials = username != null ? Optional.of(MongoClientAction.credentials("admin", username, password)) : Optional.empty();
        if (replication.isPresent() && version.enabled(Feature.RS_INITIATE)) {
            Consumer<RunningMongodProcess> initReplicaSet = runningMongodProcess -> {
                ServerAddress serverAddress = runningMongodProcess.getServerAddress();
                this.executeClientAction((RunningMongodProcess)runningMongodProcess, MongoClientAction.runCommand("admin", new Document("replSetInitiate", (Object)new Document("_id", (Object)((Storage)replication.get()).getReplSetName()).append("members", Collections.singletonList(new Document("_id", (Object)0).append("host", (Object)(serverAddress.getHost() + ":" + serverAddress.getPort())))))).withCredentials(credentials));
            };
            builder.onStateReached(StateID.of(RunningMongodProcess.class), initReplicaSet.andThen(runningMongodProcess -> {
                long diff;
                AtomicBoolean isMaster = new AtomicBoolean();
                ImmutableMongoClientAction checkIfMaster = MongoClientAction.runCommand("admin", new Document("isMaster", (Object)1)).withOnResult(doc -> isMaster.set(doc.getBoolean((Object)"ismaster"))).withCredentials(credentials);
                long started = System.currentTimeMillis();
                do {
                    this.executeClientAction((RunningMongodProcess)runningMongodProcess, checkIfMaster);
                    diff = System.currentTimeMillis() - started;
                    logger.info("check if server is elected as master: {} (after {} ms)", (Object)isMaster.get(), (Object)diff);
                    Try.run(() -> Thread.sleep(100L));
                } while (!isMaster.get() && diff < 1000L);
                if (!isMaster.get()) {
                    throw new IllegalArgumentException("initReplicaSet failed to elect " + runningMongodProcess.getServerAddress() + " as master after " + Duration.ofMillis(diff));
                }
            }));
        }
        return builder.build();
    }

    private Consumer<RunningMongodProcess> executeClientActions(List<? extends MongoClientAction> actions) {
        return runningMongodProcess -> this.executeClientActions((RunningMongodProcess)runningMongodProcess, actions);
    }

    private void executeClientActions(RunningMongodProcess runningMongodProcess, List<? extends MongoClientAction> actions) {
        for (MongoClientAction mongoClientAction : actions) {
            this.executeClientAction(runningMongodProcess, mongoClientAction);
        }
    }

    private void executeClientAction(RunningMongodProcess runningMongodProcess, MongoClientAction action) {
        try (Closeable client = action.credentials().map(c -> this.client(runningMongodProcess.getServerAddress(), MongoCredential.createCredential((String)c.username(), (String)c.database(), (char[])c.password().toCharArray()))).orElseGet(() -> this.client(runningMongodProcess.getServerAddress()));){
            logger.info("credentials: {}, action: {}", action.credentials(), (Object)action.action());
            action.onResult().accept(this.resultOfAction(client, action.action()));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (RuntimeException rx) {
            action.onError().accept(rx);
        }
    }

    protected abstract C client(ServerAddress var1);

    protected abstract C client(ServerAddress var1, MongoCredential var2);

    protected abstract Document resultOfAction(C var1, MongoClientAction.Action var2);

    private static List<? extends MongoClientAction> createAdminUserWithDatabaseAccess(String username, char[] password, String databaseName) {
        List<ImmutableMongoClientAction> actions = Arrays.asList(MongoClientAction.createUser("admin", username, password, "root"), MongoClientAction.createUser(databaseName, username, password, "readWrite").withCredentials(MongoClientAction.credentials("admin", username, password)), MongoClientAction.runCommand(databaseName, MongoClientAction.listCollections()).withCredentials(MongoClientAction.credentials(databaseName, username, password)));
        return actions;
    }

    private static MongoClientAction shutdown(String username, char[] password) {
        return MongoClientAction.shutdown("admin").withCredentials(MongoClientAction.credentials("admin", username, password)).withOnError(ex -> logger.debug("expected send shutdown exception", (Throwable)ex));
    }
}

