package de.flapdoodle.embed.mongo.packageresolver;

import de.flapdoodle.os.BitSize;
import de.flapdoodle.os.CPUType;
import de.flapdoodle.os.OS;
import de.flapdoodle.os.Version;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link PlatformMatch}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutablePlatformMatch.builder()}.
 */
@Generated(from = "PlatformMatch", generator = "Immutables")
@SuppressWarnings({"all"})
public final class ImmutablePlatformMatch implements PlatformMatch {
  private final Set<Version> version;
  private final CPUType cpuType;
  private final BitSize bitSize;
  private final OS os;

  private ImmutablePlatformMatch(
      Set<Version> version,
      CPUType cpuType,
      BitSize bitSize,
      OS os) {
    this.version = version;
    this.cpuType = cpuType;
    this.bitSize = bitSize;
    this.os = os;
  }

  /**
   * @return The value of the {@code version} attribute
   */
  @Override
  public Set<Version> version() {
    return version;
  }

  /**
   * @return The value of the {@code cpuType} attribute
   */
  @Override
  public Optional<CPUType> cpuType() {
    return Optional.ofNullable(cpuType);
  }

  /**
   * @return The value of the {@code bitSize} attribute
   */
  @Override
  public Optional<BitSize> bitSize() {
    return Optional.ofNullable(bitSize);
  }

  /**
   * @return The value of the {@code os} attribute
   */
  @Override
  public Optional<OS> os() {
    return Optional.ofNullable(os);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link PlatformMatch#version() version}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePlatformMatch withVersion(Version... elements) {
    Set<Version> newValue = createUnmodifiableSet(createSafeList(Arrays.asList(elements), true, false));
    return new ImmutablePlatformMatch(newValue, this.cpuType, this.bitSize, this.os);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link PlatformMatch#version() version}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of version elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePlatformMatch withVersion(Iterable<? extends Version> elements) {
    if (this.version == elements) return this;
    Set<Version> newValue = createUnmodifiableSet(createSafeList(elements, true, false));
    return new ImmutablePlatformMatch(newValue, this.cpuType, this.bitSize, this.os);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link PlatformMatch#cpuType() cpuType} attribute.
   * @param value The value for cpuType
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePlatformMatch withCpuType(CPUType value) {
    CPUType newValue = Objects.requireNonNull(value, "cpuType");
    if (this.cpuType == newValue) return this;
    return new ImmutablePlatformMatch(this.version, newValue, this.bitSize, this.os);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link PlatformMatch#cpuType() cpuType} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for cpuType
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final ImmutablePlatformMatch withCpuType(Optional<? extends CPUType> optional) {
    CPUType value = optional.orElse(null);
    if (this.cpuType == value) return this;
    return new ImmutablePlatformMatch(this.version, value, this.bitSize, this.os);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link PlatformMatch#bitSize() bitSize} attribute.
   * @param value The value for bitSize
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePlatformMatch withBitSize(BitSize value) {
    BitSize newValue = Objects.requireNonNull(value, "bitSize");
    if (this.bitSize == newValue) return this;
    return new ImmutablePlatformMatch(this.version, this.cpuType, newValue, this.os);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link PlatformMatch#bitSize() bitSize} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for bitSize
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final ImmutablePlatformMatch withBitSize(Optional<? extends BitSize> optional) {
    BitSize value = optional.orElse(null);
    if (this.bitSize == value) return this;
    return new ImmutablePlatformMatch(this.version, this.cpuType, value, this.os);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link PlatformMatch#os() os} attribute.
   * @param value The value for os
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePlatformMatch withOs(OS value) {
    OS newValue = Objects.requireNonNull(value, "os");
    if (this.os == newValue) return this;
    return new ImmutablePlatformMatch(this.version, this.cpuType, this.bitSize, newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link PlatformMatch#os() os} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for os
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final ImmutablePlatformMatch withOs(Optional<? extends OS> optional) {
    OS value = optional.orElse(null);
    if (this.os == value) return this;
    return new ImmutablePlatformMatch(this.version, this.cpuType, this.bitSize, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutablePlatformMatch} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutablePlatformMatch
        && equalTo(0, (ImmutablePlatformMatch) another);
  }

  private boolean equalTo(int synthetic, ImmutablePlatformMatch another) {
    return version.equals(another.version)
        && Objects.equals(cpuType, another.cpuType)
        && Objects.equals(bitSize, another.bitSize)
        && Objects.equals(os, another.os);
  }

  /**
   * Computes a hash code from attributes: {@code version}, {@code cpuType}, {@code bitSize}, {@code os}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + version.hashCode();
    h += (h << 5) + Objects.hashCode(cpuType);
    h += (h << 5) + Objects.hashCode(bitSize);
    h += (h << 5) + Objects.hashCode(os);
    return h;
  }

  /**
   * Prints the immutable value {@code PlatformMatch} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("PlatformMatch{");
    builder.append("version=").append(version);
    if (cpuType != null) {
      builder.append(", ");
      builder.append("cpuType=").append(cpuType);
    }
    if (bitSize != null) {
      builder.append(", ");
      builder.append("bitSize=").append(bitSize);
    }
    if (os != null) {
      builder.append(", ");
      builder.append("os=").append(os);
    }
    return builder.append("}").toString();
  }

  /**
   * Creates an immutable copy of a {@link PlatformMatch} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable PlatformMatch instance
   */
  public static ImmutablePlatformMatch copyOf(PlatformMatch instance) {
    if (instance instanceof ImmutablePlatformMatch) {
      return (ImmutablePlatformMatch) instance;
    }
    return ImmutablePlatformMatch.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutablePlatformMatch ImmutablePlatformMatch}.
   * <pre>
   * ImmutablePlatformMatch.builder()
   *    .addVersion|addAllVersion(de.flapdoodle.os.Version) // {@link PlatformMatch#version() version} elements
   *    .cpuType(de.flapdoodle.os.CPUType) // optional {@link PlatformMatch#cpuType() cpuType}
   *    .bitSize(de.flapdoodle.os.BitSize) // optional {@link PlatformMatch#bitSize() bitSize}
   *    .os(de.flapdoodle.os.OS) // optional {@link PlatformMatch#os() os}
   *    .build();
   * </pre>
   * @return A new ImmutablePlatformMatch builder
   */
  public static ImmutablePlatformMatch.Builder builder() {
    return new ImmutablePlatformMatch.Builder();
  }

  /**
   * Builds instances of type {@link ImmutablePlatformMatch ImmutablePlatformMatch}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "PlatformMatch", generator = "Immutables")
  public static final class Builder {
    private List<Version> version = new ArrayList<Version>();
    private CPUType cpuType;
    private BitSize bitSize;
    private OS os;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code PlatformMatch} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(PlatformMatch instance) {
      Objects.requireNonNull(instance, "instance");
      addAllVersion(instance.version());
      Optional<CPUType> cpuTypeOptional = instance.cpuType();
      if (cpuTypeOptional.isPresent()) {
        cpuType(cpuTypeOptional);
      }
      Optional<BitSize> bitSizeOptional = instance.bitSize();
      if (bitSizeOptional.isPresent()) {
        bitSize(bitSizeOptional);
      }
      Optional<OS> osOptional = instance.os();
      if (osOptional.isPresent()) {
        os(osOptional);
      }
      return this;
    }

    /**
     * Adds one element to {@link PlatformMatch#version() version} set.
     * @param element A version element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addVersion(Version element) {
      this.version.add(Objects.requireNonNull(element, "version element"));
      return this;
    }

    /**
     * Adds elements to {@link PlatformMatch#version() version} set.
     * @param elements An array of version elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addVersion(Version... elements) {
      for (Version element : elements) {
        this.version.add(Objects.requireNonNull(element, "version element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link PlatformMatch#version() version} set.
     * @param elements An iterable of version elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder version(Iterable<? extends Version> elements) {
      this.version.clear();
      return addAllVersion(elements);
    }

    /**
     * Adds elements to {@link PlatformMatch#version() version} set.
     * @param elements An iterable of version elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllVersion(Iterable<? extends Version> elements) {
      for (Version element : elements) {
        this.version.add(Objects.requireNonNull(element, "version element"));
      }
      return this;
    }

    /**
     * Initializes the optional value {@link PlatformMatch#cpuType() cpuType} to cpuType.
     * @param cpuType The value for cpuType
     * @return {@code this} builder for chained invocation
     */
    public final Builder cpuType(CPUType cpuType) {
      this.cpuType = Objects.requireNonNull(cpuType, "cpuType");
      return this;
    }

    /**
     * Initializes the optional value {@link PlatformMatch#cpuType() cpuType} to cpuType.
     * @param cpuType The value for cpuType
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder cpuType(Optional<? extends CPUType> cpuType) {
      this.cpuType = cpuType.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link PlatformMatch#bitSize() bitSize} to bitSize.
     * @param bitSize The value for bitSize
     * @return {@code this} builder for chained invocation
     */
    public final Builder bitSize(BitSize bitSize) {
      this.bitSize = Objects.requireNonNull(bitSize, "bitSize");
      return this;
    }

    /**
     * Initializes the optional value {@link PlatformMatch#bitSize() bitSize} to bitSize.
     * @param bitSize The value for bitSize
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder bitSize(Optional<? extends BitSize> bitSize) {
      this.bitSize = bitSize.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link PlatformMatch#os() os} to os.
     * @param os The value for os
     * @return {@code this} builder for chained invocation
     */
    public final Builder os(OS os) {
      this.os = Objects.requireNonNull(os, "os");
      return this;
    }

    /**
     * Initializes the optional value {@link PlatformMatch#os() os} to os.
     * @param os The value for os
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder os(Optional<? extends OS> os) {
      this.os = os.orElse(null);
      return this;
    }

    /**
     * Builds a new {@link ImmutablePlatformMatch ImmutablePlatformMatch}.
     * @return An immutable instance of PlatformMatch
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutablePlatformMatch build() {
      return new ImmutablePlatformMatch(createUnmodifiableSet(version), cpuType, bitSize, os);
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  /** Unmodifiable set constructed from list to avoid rehashing. */
  private static <T> Set<T> createUnmodifiableSet(List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptySet();
    case 1: return Collections.singleton(list.get(0));
    default:
      Set<T> set = new LinkedHashSet<>(list.size());
      set.addAll(list);
      return Collections.unmodifiableSet(set);
    }
  }
}
