/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.mongo.packageresolver.linux;

import de.flapdoodle.embed.mongo.packageresolver.AbstractPackageFinder;
import de.flapdoodle.embed.mongo.packageresolver.Command;
import de.flapdoodle.embed.mongo.packageresolver.DistributionMatch;
import de.flapdoodle.embed.mongo.packageresolver.HasLabel;
import de.flapdoodle.embed.mongo.packageresolver.ImmutablePackageFinderRule;
import de.flapdoodle.embed.mongo.packageresolver.ImmutablePackageFinderRules;
import de.flapdoodle.embed.mongo.packageresolver.PackageFinderRule;
import de.flapdoodle.embed.mongo.packageresolver.PackageFinderRules;
import de.flapdoodle.embed.mongo.packageresolver.ToolVersionRange;
import de.flapdoodle.embed.mongo.packageresolver.UrlTemplatePackageFinder;
import de.flapdoodle.embed.mongo.packageresolver.VersionRange;
import de.flapdoodle.embed.process.config.store.FileSet;
import de.flapdoodle.embed.process.config.store.FileType;
import de.flapdoodle.embed.process.distribution.ArchiveType;
import de.flapdoodle.os.BitSize;
import de.flapdoodle.os.CPUType;
import de.flapdoodle.os.CommonOS;
import de.flapdoodle.os.OS;
import de.flapdoodle.os.Version;
import de.flapdoodle.os.linux.DebianVersion;

public class DebianPackageFinder
extends AbstractPackageFinder
implements HasLabel {
    public DebianPackageFinder(Command command) {
        super(command, DebianPackageFinder.rules(command));
    }

    @Override
    public String label() {
        return this.getClass().getSimpleName();
    }

    private static FileSet fileSetOf(Command command) {
        return FileSet.builder().addEntry(FileType.Executable, command.commandName()).build();
    }

    private static ImmutablePackageFinderRules rules(Command command) {
        FileSet fileSet = DebianPackageFinder.fileSetOf(command);
        ImmutablePackageFinderRule devRule_DEBIAN_12_X86_B64 = PackageFinderRule.builder().match(DebianPackageFinder.match((OS)CommonOS.Linux, BitSize.B64, CPUType.X86, new Version[]{DebianVersion.DEBIAN_12}).andThen(DistributionMatch.any(VersionRange.of("8.0.0-rc9"), VersionRange.of("8.0.0-rc7"), VersionRange.of("8.0.0-rc3"), VersionRange.of("7.3.3-rc0"), VersionRange.of("7.3.0", "7.3.3"), VersionRange.of("7.2.0-rc3"), VersionRange.of("7.0.8-rc0")))).finder(UrlTemplatePackageFinder.builder().fileSet(fileSet).archiveType(ArchiveType.TGZ).urlTemplate("/linux/mongodb-linux-x86_64-debian12-{version}.tgz").isDevVersion(true).build()).build();
        ImmutablePackageFinderRule rule_DEBIAN_12_X86_B64 = PackageFinderRule.builder().match(DebianPackageFinder.match((OS)CommonOS.Linux, BitSize.B64, CPUType.X86, new Version[]{DebianVersion.DEBIAN_12}).andThen(DistributionMatch.any(VersionRange.of("7.0.11", "7.0.12"), VersionRange.of("7.0.5", "7.0.9")))).finder(UrlTemplatePackageFinder.builder().fileSet(fileSet).archiveType(ArchiveType.TGZ).urlTemplate("/linux/mongodb-linux-x86_64-debian12-{version}.tgz").build()).build();
        ImmutablePackageFinderRule tools_DEBIAN_12_X86_B64 = PackageFinderRule.builder().match(DebianPackageFinder.match((OS)CommonOS.Linux, BitSize.B64, CPUType.X86, new Version[]{DebianVersion.DEBIAN_12}).andThen(DistributionMatch.any(ToolVersionRange.of("100.9.2", "100.9.5")))).finder(UrlTemplatePackageFinder.builder().fileSet(fileSet).archiveType(ArchiveType.TGZ).urlTemplate("/tools/db/mongodb-database-tools-debian12-x86_64-{tools.version}.tgz").build()).build();
        ImmutablePackageFinderRule devRule_DEBIAN_11_X86_B64 = PackageFinderRule.builder().match(DebianPackageFinder.match((OS)CommonOS.Linux, BitSize.B64, CPUType.X86, new Version[]{DebianVersion.DEBIAN_11}).andThen(DistributionMatch.any(VersionRange.of("7.3.3-rc0"), VersionRange.of("7.3.0", "7.3.3"), VersionRange.of("7.2.0-rc3"), VersionRange.of("7.1.0", "7.1.1"), VersionRange.of("7.0.8-rc0"), VersionRange.of("7.0.3-rc1"), VersionRange.of("7.0.0-rc8"), VersionRange.of("7.0.0-rc2"), VersionRange.of("7.0.0-rc10"), VersionRange.of("7.0.0-rc1"), VersionRange.of("6.3.1", "6.3.2"), VersionRange.of("6.0.16-rc0"), VersionRange.of("6.0.9-rc1"), VersionRange.of("5.0.28-rc0"), VersionRange.of("5.0.20-rc1")))).finder(UrlTemplatePackageFinder.builder().fileSet(fileSet).archiveType(ArchiveType.TGZ).urlTemplate("/linux/mongodb-linux-x86_64-debian11-{version}.tgz").isDevVersion(true).build()).build();
        ImmutablePackageFinderRule rule_DEBIAN_11_X86_B64 = PackageFinderRule.builder().match(DebianPackageFinder.match((OS)CommonOS.Linux, BitSize.B64, CPUType.X86, new Version[]{DebianVersion.DEBIAN_11}).andThen(DistributionMatch.any(VersionRange.of("7.0.11", "7.0.12"), VersionRange.of("7.0.0", "7.0.9"), VersionRange.of("6.0.0", "6.0.16"), VersionRange.of("5.0.8", "5.0.27")))).finder(UrlTemplatePackageFinder.builder().fileSet(fileSet).archiveType(ArchiveType.TGZ).urlTemplate("/linux/mongodb-linux-x86_64-debian11-{version}.tgz").build()).build();
        ImmutablePackageFinderRule tools_DEBIAN_11_X86_B64 = PackageFinderRule.builder().match(DebianPackageFinder.match((OS)CommonOS.Linux, BitSize.B64, CPUType.X86, new Version[]{DebianVersion.DEBIAN_11}).andThen(DistributionMatch.any(ToolVersionRange.of("100.9.0", "100.9.5"), ToolVersionRange.of("100.8.0"), ToolVersionRange.of("100.7.0", "100.7.5"), ToolVersionRange.of("100.6.0", "100.6.1"), ToolVersionRange.of("100.5.3", "100.5.4")))).finder(UrlTemplatePackageFinder.builder().fileSet(fileSet).archiveType(ArchiveType.TGZ).urlTemplate("/tools/db/mongodb-database-tools-debian11-x86_64-{tools.version}.tgz").build()).build();
        ImmutablePackageFinderRule devRule_DEBIAN_10_X86_B64 = PackageFinderRule.builder().match(DebianPackageFinder.match((OS)CommonOS.Linux, BitSize.B64, CPUType.X86, new Version[]{DebianVersion.DEBIAN_10}).andThen(DistributionMatch.any(VersionRange.of("7.0.0-rc2"), VersionRange.of("7.0.0-rc1"), VersionRange.of("6.3.1", "6.3.2"), VersionRange.of("6.0.16-rc0"), VersionRange.of("6.0.9-rc1"), VersionRange.of("5.0.28-rc0"), VersionRange.of("5.0.20-rc1"), VersionRange.of("4.4.27-rc0"), VersionRange.of("4.4.24-rc0")))).finder(UrlTemplatePackageFinder.builder().fileSet(fileSet).archiveType(ArchiveType.TGZ).urlTemplate("/linux/mongodb-linux-x86_64-debian10-{version}.tgz").isDevVersion(true).build()).build();
        ImmutablePackageFinderRule rule_DEBIAN_10_X86_B64 = PackageFinderRule.builder().match(DebianPackageFinder.match((OS)CommonOS.Linux, BitSize.B64, CPUType.X86, new Version[]{DebianVersion.DEBIAN_10}).andThen(DistributionMatch.any(VersionRange.of("6.0.0", "6.0.16"), VersionRange.of("5.0.0", "5.0.27"), VersionRange.of("4.4.0", "4.4.29"), VersionRange.of("4.2.5", "4.2.25"), VersionRange.of("4.2.1", "4.2.3")))).finder(UrlTemplatePackageFinder.builder().fileSet(fileSet).archiveType(ArchiveType.TGZ).urlTemplate("/linux/mongodb-linux-x86_64-debian10-{version}.tgz").build()).build();
        ImmutablePackageFinderRule tools_DEBIAN_10_X86_B64 = PackageFinderRule.builder().match(DebianPackageFinder.match((OS)CommonOS.Linux, BitSize.B64, CPUType.X86, new Version[]{DebianVersion.DEBIAN_10}).andThen(DistributionMatch.any(ToolVersionRange.of("100.9.0", "100.9.5"), ToolVersionRange.of("100.8.0"), ToolVersionRange.of("100.7.0", "100.7.5"), ToolVersionRange.of("100.6.0", "100.6.1"), ToolVersionRange.of("100.5.0", "100.5.4"), ToolVersionRange.of("100.4.0", "100.4.1"), ToolVersionRange.of("100.3.0", "100.3.1"), ToolVersionRange.of("100.2.0", "100.2.1"), ToolVersionRange.of("100.1.0", "100.1.1"), ToolVersionRange.of("100.0.0", "100.0.2"), ToolVersionRange.of("99.0.0")))).finder(UrlTemplatePackageFinder.builder().fileSet(fileSet).archiveType(ArchiveType.TGZ).urlTemplate("/tools/db/mongodb-database-tools-debian10-x86_64-{tools.version}.tgz").build()).build();
        ImmutablePackageFinderRule devRule_DEBIAN_9_X86_B64 = PackageFinderRule.builder().match(DebianPackageFinder.match((OS)CommonOS.Linux, BitSize.B64, CPUType.X86, new Version[]{DebianVersion.DEBIAN_9}).andThen(DistributionMatch.any(VersionRange.of("5.0.28-rc0"), VersionRange.of("5.0.20-rc1"), VersionRange.of("4.4.27-rc0"), VersionRange.of("4.4.24-rc0")))).finder(UrlTemplatePackageFinder.builder().fileSet(fileSet).archiveType(ArchiveType.TGZ).urlTemplate("/linux/mongodb-linux-x86_64-debian92-{version}.tgz").isDevVersion(true).build()).build();
        ImmutablePackageFinderRule rule_DEBIAN_9_X86_B64 = PackageFinderRule.builder().match(DebianPackageFinder.match((OS)CommonOS.Linux, BitSize.B64, CPUType.X86, new Version[]{DebianVersion.DEBIAN_9}).andThen(DistributionMatch.any(VersionRange.of("5.0.0", "5.0.27"), VersionRange.of("4.4.0", "4.4.29"), VersionRange.of("4.2.5", "4.2.25"), VersionRange.of("4.2.0", "4.2.3"), VersionRange.of("4.0.0", "4.0.28"), VersionRange.of("3.6.5", "3.6.23")))).finder(UrlTemplatePackageFinder.builder().fileSet(fileSet).archiveType(ArchiveType.TGZ).urlTemplate("/linux/mongodb-linux-x86_64-debian92-{version}.tgz").build()).build();
        ImmutablePackageFinderRule tools_DEBIAN_9_X86_B64 = PackageFinderRule.builder().match(DebianPackageFinder.match((OS)CommonOS.Linux, BitSize.B64, CPUType.X86, new Version[]{DebianVersion.DEBIAN_9}).andThen(DistributionMatch.any(ToolVersionRange.of("100.9.0", "100.9.5"), ToolVersionRange.of("100.8.0"), ToolVersionRange.of("100.7.0", "100.7.5"), ToolVersionRange.of("100.6.0", "100.6.1"), ToolVersionRange.of("100.5.0", "100.5.4"), ToolVersionRange.of("100.4.0", "100.4.1"), ToolVersionRange.of("100.3.0", "100.3.1"), ToolVersionRange.of("100.2.0", "100.2.1"), ToolVersionRange.of("100.1.0", "100.1.1"), ToolVersionRange.of("100.0.0", "100.0.2"), ToolVersionRange.of("99.0.0")))).finder(UrlTemplatePackageFinder.builder().fileSet(fileSet).archiveType(ArchiveType.TGZ).urlTemplate("/tools/db/mongodb-database-tools-debian92-x86_64-{tools.version}.tgz").build()).build();
        switch (command) {
            case MongoDump: 
            case MongoImport: 
            case MongoRestore: {
                return PackageFinderRules.empty().withAdditionalRules(tools_DEBIAN_12_X86_B64).withAdditionalRules(tools_DEBIAN_11_X86_B64).withAdditionalRules(tools_DEBIAN_10_X86_B64).withAdditionalRules(tools_DEBIAN_9_X86_B64).withAdditionalRules(devRule_DEBIAN_10_X86_B64, rule_DEBIAN_10_X86_B64).withAdditionalRules(devRule_DEBIAN_9_X86_B64, rule_DEBIAN_9_X86_B64);
            }
        }
        return PackageFinderRules.empty().withAdditionalRules(devRule_DEBIAN_12_X86_B64, rule_DEBIAN_12_X86_B64).withAdditionalRules(devRule_DEBIAN_11_X86_B64, rule_DEBIAN_11_X86_B64).withAdditionalRules(devRule_DEBIAN_10_X86_B64, rule_DEBIAN_10_X86_B64).withAdditionalRules(devRule_DEBIAN_9_X86_B64, rule_DEBIAN_9_X86_B64);
    }
}

