/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.mongo.packageresolver;

import de.flapdoodle.embed.mongo.packageresolver.NumericVersion;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;

public final class ImmutableNumericVersion
implements NumericVersion {
    private final int major;
    private final int minor;
    private final int patch;
    private final String build;

    private ImmutableNumericVersion(int major, int minor, int patch) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
        this.build = null;
    }

    private ImmutableNumericVersion(int major, int minor, int patch, String build) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
        this.build = build;
    }

    @Override
    public int major() {
        return this.major;
    }

    @Override
    public int minor() {
        return this.minor;
    }

    @Override
    public int patch() {
        return this.patch;
    }

    @Override
    public Optional<String> build() {
        return Optional.ofNullable(this.build);
    }

    public final ImmutableNumericVersion withMajor(int value) {
        if (this.major == value) {
            return this;
        }
        return new ImmutableNumericVersion(value, this.minor, this.patch, this.build);
    }

    public final ImmutableNumericVersion withMinor(int value) {
        if (this.minor == value) {
            return this;
        }
        return new ImmutableNumericVersion(this.major, value, this.patch, this.build);
    }

    public final ImmutableNumericVersion withPatch(int value) {
        if (this.patch == value) {
            return this;
        }
        return new ImmutableNumericVersion(this.major, this.minor, value, this.build);
    }

    public final ImmutableNumericVersion withBuild(String value) {
        String newValue = Objects.requireNonNull(value, "build");
        if (Objects.equals(this.build, newValue)) {
            return this;
        }
        return new ImmutableNumericVersion(this.major, this.minor, this.patch, newValue);
    }

    public final ImmutableNumericVersion withBuild(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.build, value)) {
            return this;
        }
        return new ImmutableNumericVersion(this.major, this.minor, this.patch, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableNumericVersion && this.equalTo(0, (ImmutableNumericVersion)another);
    }

    private boolean equalTo(int synthetic, ImmutableNumericVersion another) {
        return this.major == another.major && this.minor == another.minor && this.patch == another.patch && Objects.equals(this.build, another.build);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.major;
        h += (h << 5) + this.minor;
        h += (h << 5) + this.patch;
        h += (h << 5) + Objects.hashCode(this.build);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("NumericVersion{");
        builder.append("major=").append(this.major);
        builder.append(", ");
        builder.append("minor=").append(this.minor);
        builder.append(", ");
        builder.append("patch=").append(this.patch);
        if (this.build != null) {
            builder.append(", ");
            builder.append("build=").append(this.build);
        }
        return builder.append("}").toString();
    }

    public static ImmutableNumericVersion of(int major, int minor, int patch) {
        return new ImmutableNumericVersion(major, minor, patch);
    }

    public static ImmutableNumericVersion copyOf(NumericVersion instance) {
        if (instance instanceof ImmutableNumericVersion) {
            return (ImmutableNumericVersion)instance;
        }
        return ImmutableNumericVersion.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_MAJOR = 1L;
        private static final long INIT_BIT_MINOR = 2L;
        private static final long INIT_BIT_PATCH = 4L;
        private long initBits = 7L;
        private int major;
        private int minor;
        private int patch;
        private String build;

        private Builder() {
        }

        public final Builder from(NumericVersion instance) {
            Objects.requireNonNull(instance, "instance");
            this.major(instance.major());
            this.minor(instance.minor());
            this.patch(instance.patch());
            Optional<String> buildOptional = instance.build();
            if (buildOptional.isPresent()) {
                this.build(buildOptional);
            }
            return this;
        }

        public final Builder major(int major) {
            this.major = major;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder minor(int minor) {
            this.minor = minor;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder patch(int patch) {
            this.patch = patch;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder build(String build) {
            this.build = Objects.requireNonNull(build, "build");
            return this;
        }

        public final Builder build(Optional<String> build) {
            this.build = build.orElse(null);
            return this;
        }

        public ImmutableNumericVersion build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableNumericVersion(this.major, this.minor, this.patch, this.build);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("major");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("minor");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("patch");
            }
            return "Cannot build NumericVersion, some of required attributes are not set " + attributes;
        }
    }
}

