/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.os;

import de.flapdoodle.os.Platform;
import de.flapdoodle.os.Version;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public interface VersionWithPriority
extends Version {
    public int priority();

    public static int priorityOf(Optional<? extends Version> version) {
        return version.map(v -> v instanceof VersionWithPriority ? ((VersionWithPriority)v).priority() : 0).orElse(0);
    }

    public static List<Platform> sorteByPriority(List<? extends Platform> list) {
        return list.stream().sorted((a, b) -> Integer.compare(VersionWithPriority.priorityOf(b.version()), VersionWithPriority.priorityOf(a.version()))).collect(Collectors.toList());
    }
}

