/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.os.common.attributes;

import de.flapdoodle.os.common.attributes.Attribute;
import de.flapdoodle.os.common.attributes.AttributeExtractor;
import de.flapdoodle.os.common.attributes.AttributeExtractorLookup;
import de.flapdoodle.os.common.matcher.Match;
import de.flapdoodle.os.common.matcher.Matcher;
import de.flapdoodle.os.common.matcher.MatcherLookup;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LoggingWrapper {
    private LoggingWrapper() {
    }

    public static AttributeExtractorLookup wrap(AttributeExtractorLookup delegate) {
        return new AttributeExtractorLookupWrapper(delegate);
    }

    public static MatcherLookup wrap(MatcherLookup delegate) {
        return new MatcherLookupWrapper(delegate);
    }

    static class MatcherWrapper<T, M extends Match<T>>
    implements Matcher<T, M> {
        private static Logger logger = LoggerFactory.getLogger(MatcherWrapper.class);
        private final Matcher<T, M> delegate;

        public MatcherWrapper(Matcher<T, M> delegate) {
            this.delegate = delegate;
        }

        @Override
        public boolean match(Optional<T> value, M match) {
            boolean matches = this.delegate.match(value, match);
            logger.info("value {} matches {}: {}", new Object[]{value, match, matches});
            return matches;
        }
    }

    static class MatcherLookupWrapper
    implements MatcherLookup {
        private static Logger logger = LoggerFactory.getLogger(MatcherLookupWrapper.class);
        private final MatcherLookup delegate;

        private MatcherLookupWrapper(MatcherLookup delegate) {
            this.delegate = delegate;
        }

        @Override
        public <T, M extends Match<T>> Optional<Matcher<T, M>> matcher(M match) {
            Optional<Matcher<Matcher, M>> matcher = this.delegate.matcher(match);
            logger.info("matcher for attribute {}: {}", match, matcher);
            return matcher.map(MatcherWrapper::new);
        }
    }

    static class AttributeExtractorLookupWrapper
    implements AttributeExtractorLookup {
        private static Logger logger = LoggerFactory.getLogger(AttributeExtractorLookupWrapper.class);
        private final AttributeExtractorLookup delegate;

        private AttributeExtractorLookupWrapper(AttributeExtractorLookup delegate) {
            this.delegate = delegate;
        }

        @Override
        public <T, A extends Attribute<T>> Optional<AttributeExtractor<T, A>> extractor(A attribute) {
            Optional extractor = this.delegate.extractor(attribute);
            logger.info("extractor for attribute {}: {}", attribute, extractor);
            return extractor;
        }
    }
}

