/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.os.common.types;

import de.flapdoodle.os.common.types.ImmutableLsbReleaseFile;
import de.flapdoodle.os.common.types.LsbReleaseFile;
import java.util.function.Function;

public class LsbReleaseFileConverter
implements Function<String, LsbReleaseFile> {
    public static final LsbReleaseFileConverter INSTANCE = new LsbReleaseFileConverter();

    @Override
    public LsbReleaseFile apply(String s) {
        return LsbReleaseFileConverter.convert(s);
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public static LsbReleaseFile convert(String content) {
        String[] lines = content.split("[\n\r]+");
        ImmutableLsbReleaseFile.Builder builder = ImmutableLsbReleaseFile.builder();
        for (String line : lines) {
            int idx = line.indexOf("=");
            if (idx == -1) continue;
            String key = line.substring(0, idx).trim();
            String value = line.substring(idx + 1).trim();
            if (value.charAt(0) == '\"' && value.charAt(value.length() - 1) == '\"') {
                value = value.substring(1, value.length() - 1);
            }
            builder.putAttributes(key, value);
        }
        return builder.build();
    }
}

