/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.os.common.attributes;

import de.flapdoodle.os.common.attributes.MappedTextFile;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Objects;
import java.util.function.Function;
import org.immutables.value.Generated;

@Generated(from="MappedTextFile", generator="Immutables")
public final class ImmutableMappedTextFile<T>
implements MappedTextFile<T> {
    private final String name;
    private final Function<String, T> converter;
    private final Charset charset;

    private ImmutableMappedTextFile(String name, Function<String, T> converter) {
        this.name = Objects.requireNonNull(name, "name");
        this.converter = Objects.requireNonNull(converter, "converter");
        this.charset = Objects.requireNonNull(MappedTextFile.super.charset(), "charset");
    }

    private ImmutableMappedTextFile(Builder<T> builder) {
        this.name = ((Builder)builder).name;
        this.converter = ((Builder)builder).converter;
        this.charset = ((Builder)builder).charset != null ? ((Builder)builder).charset : Objects.requireNonNull(MappedTextFile.super.charset(), "charset");
    }

    private ImmutableMappedTextFile(String name, Function<String, T> converter, Charset charset) {
        this.name = name;
        this.converter = converter;
        this.charset = charset;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public Function<String, T> converter() {
        return this.converter;
    }

    @Override
    public Charset charset() {
        return this.charset;
    }

    public final ImmutableMappedTextFile<T> withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableMappedTextFile<T>(newValue, this.converter, this.charset);
    }

    public final ImmutableMappedTextFile<T> withConverter(Function<String, T> value) {
        if (this.converter == value) {
            return this;
        }
        Function<String, T> newValue = Objects.requireNonNull(value, "converter");
        return new ImmutableMappedTextFile<T>(this.name, newValue, this.charset);
    }

    public final ImmutableMappedTextFile<T> withCharset(Charset value) {
        if (this.charset == value) {
            return this;
        }
        Charset newValue = Objects.requireNonNull(value, "charset");
        return new ImmutableMappedTextFile<T>(this.name, this.converter, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMappedTextFile && this.equalTo(0, (ImmutableMappedTextFile)another);
    }

    private boolean equalTo(int synthetic, ImmutableMappedTextFile<?> another) {
        return this.name.equals(another.name) && this.converter.equals(another.converter) && this.charset.equals(another.charset);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.converter.hashCode();
        h += (h << 5) + this.charset.hashCode();
        return h;
    }

    public String toString() {
        return "MappedTextFile{name=" + this.name + ", converter=" + this.converter + ", charset=" + this.charset + "}";
    }

    public static <T> ImmutableMappedTextFile<T> of(String name, Function<String, T> converter) {
        return new ImmutableMappedTextFile<T>(name, converter);
    }

    public static <T> ImmutableMappedTextFile<T> copyOf(MappedTextFile<T> instance) {
        if (instance instanceof ImmutableMappedTextFile) {
            return (ImmutableMappedTextFile)instance;
        }
        return ImmutableMappedTextFile.builder().from(instance).build();
    }

    public static <T> Builder<T> builder() {
        return new Builder();
    }

    @Generated(from="MappedTextFile", generator="Immutables")
    public static final class Builder<T> {
        private static final long INIT_BIT_NAME = 1L;
        private static final long INIT_BIT_CONVERTER = 2L;
        private long initBits = 3L;
        private String name;
        private Function<String, T> converter;
        private Charset charset;

        private Builder() {
        }

        public final Builder<T> from(MappedTextFile<T> instance) {
            Objects.requireNonNull(instance, "instance");
            this.name(instance.name());
            this.converter(instance.converter());
            this.charset(instance.charset());
            return this;
        }

        public final Builder<T> name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder<T> converter(Function<String, T> converter) {
            this.converter = Objects.requireNonNull(converter, "converter");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder<T> charset(Charset charset) {
            this.charset = Objects.requireNonNull(charset, "charset");
            return this;
        }

        public ImmutableMappedTextFile<T> build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableMappedTextFile(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("converter");
            }
            return "Cannot build MappedTextFile, some of required attributes are not set " + attributes;
        }
    }
}

