package de.flapdoodle.os;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Platform}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutablePlatform.builder()}.
 */
@Generated(from = "Platform", generator = "Immutables")
@SuppressWarnings({"all"})
public final class ImmutablePlatform extends Platform {
  private final OS operatingSystem;
  private final Architecture architecture;
  private final Distribution distribution;
  private final Version version;

  private ImmutablePlatform(
      OS operatingSystem,
      Architecture architecture,
      Distribution distribution,
      Version version) {
    this.operatingSystem = operatingSystem;
    this.architecture = architecture;
    this.distribution = distribution;
    this.version = version;
  }

  /**
   * @return The value of the {@code operatingSystem} attribute
   */
  @Override
  public OS operatingSystem() {
    return operatingSystem;
  }

  /**
   * @return The value of the {@code architecture} attribute
   */
  @Override
  public Architecture architecture() {
    return architecture;
  }

  /**
   * @return The value of the {@code distribution} attribute
   */
  @Override
  public Optional<Distribution> distribution() {
    return Optional.ofNullable(distribution);
  }

  /**
   * @return The value of the {@code version} attribute
   */
  @Override
  public Optional<Version> version() {
    return Optional.ofNullable(version);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Platform#operatingSystem() operatingSystem} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for operatingSystem
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePlatform withOperatingSystem(OS value) {
    if (this.operatingSystem == value) return this;
    OS newValue = Objects.requireNonNull(value, "operatingSystem");
    return new ImmutablePlatform(newValue, this.architecture, this.distribution, this.version);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Platform#architecture() architecture} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for architecture
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePlatform withArchitecture(Architecture value) {
    if (this.architecture == value) return this;
    Architecture newValue = Objects.requireNonNull(value, "architecture");
    return new ImmutablePlatform(this.operatingSystem, newValue, this.distribution, this.version);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Platform#distribution() distribution} attribute.
   * @param value The value for distribution
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePlatform withDistribution(Distribution value) {
    Distribution newValue = Objects.requireNonNull(value, "distribution");
    if (this.distribution == newValue) return this;
    return new ImmutablePlatform(this.operatingSystem, this.architecture, newValue, this.version);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Platform#distribution() distribution} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for distribution
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final ImmutablePlatform withDistribution(Optional<? extends Distribution> optional) {
    Distribution value = optional.orElse(null);
    if (this.distribution == value) return this;
    return new ImmutablePlatform(this.operatingSystem, this.architecture, value, this.version);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Platform#version() version} attribute.
   * @param value The value for version
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePlatform withVersion(Version value) {
    Version newValue = Objects.requireNonNull(value, "version");
    if (this.version == newValue) return this;
    return new ImmutablePlatform(this.operatingSystem, this.architecture, this.distribution, newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Platform#version() version} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for version
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final ImmutablePlatform withVersion(Optional<? extends Version> optional) {
    Version value = optional.orElse(null);
    if (this.version == value) return this;
    return new ImmutablePlatform(this.operatingSystem, this.architecture, this.distribution, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutablePlatform} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutablePlatform
        && equalTo(0, (ImmutablePlatform) another);
  }

  private boolean equalTo(int synthetic, ImmutablePlatform another) {
    return operatingSystem.equals(another.operatingSystem)
        && architecture.equals(another.architecture)
        && Objects.equals(distribution, another.distribution)
        && Objects.equals(version, another.version);
  }

  /**
   * Computes a hash code from attributes: {@code operatingSystem}, {@code architecture}, {@code distribution}, {@code version}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + operatingSystem.hashCode();
    h += (h << 5) + architecture.hashCode();
    h += (h << 5) + Objects.hashCode(distribution);
    h += (h << 5) + Objects.hashCode(version);
    return h;
  }

  /**
   * Prints the immutable value {@code Platform} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("Platform{");
    builder.append("operatingSystem=").append(operatingSystem);
    builder.append(", ");
    builder.append("architecture=").append(architecture);
    if (distribution != null) {
      builder.append(", ");
      builder.append("distribution=").append(distribution);
    }
    if (version != null) {
      builder.append(", ");
      builder.append("version=").append(version);
    }
    return builder.append("}").toString();
  }

  /**
   * Creates an immutable copy of a {@link Platform} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Platform instance
   */
  public static ImmutablePlatform copyOf(Platform instance) {
    if (instance instanceof ImmutablePlatform) {
      return (ImmutablePlatform) instance;
    }
    return ImmutablePlatform.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutablePlatform ImmutablePlatform}.
   * <pre>
   * ImmutablePlatform.builder()
   *    .operatingSystem(de.flapdoodle.os.OS) // required {@link Platform#operatingSystem() operatingSystem}
   *    .architecture(de.flapdoodle.os.Architecture) // required {@link Platform#architecture() architecture}
   *    .distribution(de.flapdoodle.os.Distribution) // optional {@link Platform#distribution() distribution}
   *    .version(de.flapdoodle.os.Version) // optional {@link Platform#version() version}
   *    .build();
   * </pre>
   * @return A new ImmutablePlatform builder
   */
  public static ImmutablePlatform.Builder builder() {
    return new ImmutablePlatform.Builder();
  }

  /**
   * Builds instances of type {@link ImmutablePlatform ImmutablePlatform}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Platform", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_OPERATING_SYSTEM = 0x1L;
    private static final long INIT_BIT_ARCHITECTURE = 0x2L;
    private long initBits = 0x3L;

    private OS operatingSystem;
    private Architecture architecture;
    private Distribution distribution;
    private Version version;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Platform} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Platform instance) {
      Objects.requireNonNull(instance, "instance");
      operatingSystem(instance.operatingSystem());
      architecture(instance.architecture());
      Optional<Distribution> distributionOptional = instance.distribution();
      if (distributionOptional.isPresent()) {
        distribution(distributionOptional);
      }
      Optional<Version> versionOptional = instance.version();
      if (versionOptional.isPresent()) {
        version(versionOptional);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link Platform#operatingSystem() operatingSystem} attribute.
     * @param operatingSystem The value for operatingSystem 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder operatingSystem(OS operatingSystem) {
      this.operatingSystem = Objects.requireNonNull(operatingSystem, "operatingSystem");
      initBits &= ~INIT_BIT_OPERATING_SYSTEM;
      return this;
    }

    /**
     * Initializes the value for the {@link Platform#architecture() architecture} attribute.
     * @param architecture The value for architecture 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder architecture(Architecture architecture) {
      this.architecture = Objects.requireNonNull(architecture, "architecture");
      initBits &= ~INIT_BIT_ARCHITECTURE;
      return this;
    }

    /**
     * Initializes the optional value {@link Platform#distribution() distribution} to distribution.
     * @param distribution The value for distribution
     * @return {@code this} builder for chained invocation
     */
    public final Builder distribution(Distribution distribution) {
      this.distribution = Objects.requireNonNull(distribution, "distribution");
      return this;
    }

    /**
     * Initializes the optional value {@link Platform#distribution() distribution} to distribution.
     * @param distribution The value for distribution
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder distribution(Optional<? extends Distribution> distribution) {
      this.distribution = distribution.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link Platform#version() version} to version.
     * @param version The value for version
     * @return {@code this} builder for chained invocation
     */
    public final Builder version(Version version) {
      this.version = Objects.requireNonNull(version, "version");
      return this;
    }

    /**
     * Initializes the optional value {@link Platform#version() version} to version.
     * @param version The value for version
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder version(Optional<? extends Version> version) {
      this.version = version.orElse(null);
      return this;
    }

    /**
     * Builds a new {@link ImmutablePlatform ImmutablePlatform}.
     * @return An immutable instance of Platform
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutablePlatform build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutablePlatform(operatingSystem, architecture, distribution, version);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_OPERATING_SYSTEM) != 0) attributes.add("operatingSystem");
      if ((initBits & INIT_BIT_ARCHITECTURE) != 0) attributes.add("architecture");
      return "Cannot build Platform, some of required attributes are not set " + attributes;
    }
  }
}
