/*
 * Decompiled with CFR 0.152.
 */
package de.empulse.eclipselink.mojo;

import de.empulse.eclipselink.mojo.LogWriter;
import java.io.IOException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.eclipse.persistence.logging.AbstractSessionLog;
import org.eclipse.persistence.tools.weaving.jpa.StaticWeaveProcessor;

@Mojo(name="weave", defaultPhase=LifecyclePhase.PROCESS_CLASSES, requiresDependencyResolution=ResolutionScope.COMPILE)
public class EclipselinkStaticWeaveMojo
extends AbstractMojo {
    @Parameter(property="weave.persistenceXMLLocation")
    private String persistenceXMLLocation;
    @Parameter(property="project.build.outputDirectory")
    private String source;
    @Parameter(property="project.build.outputDirectory")
    private String target;
    @Parameter(property="weave.logLevel", defaultValue="FINE")
    private String logLevel;
    @Component
    private MavenProject project;

    public void execute() throws MojoExecutionException {
        try {
            this.getLog().info((CharSequence)"Start EclipseLink static weaving...");
            List<URL> classpath = this.buildClassPath();
            StaticWeaveProcessor weave = new StaticWeaveProcessor(this.source, this.target);
            if (!classpath.isEmpty()) {
                URLClassLoader classLoader = new URLClassLoader(classpath.toArray(new URL[0]), Thread.currentThread().getContextClassLoader());
                weave.setClassLoader((ClassLoader)classLoader);
            }
            if (this.persistenceXMLLocation != null) {
                weave.setPersistenceXMLLocation(this.persistenceXMLLocation);
            }
            weave.setLog((Writer)new LogWriter(this.getLog()));
            weave.setLogLevel(this.getLogLevel());
            weave.performWeaving();
            this.getLog().info((CharSequence)"Finished EclipseLink static weaving.");
        }
        catch (MalformedURLException e) {
            throw new MojoExecutionException("Failed", (Exception)e);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed", (Exception)e);
        }
        catch (URISyntaxException e) {
            throw new MojoExecutionException("Failed", (Exception)e);
        }
    }

    public void setLogLevel(String logLevel) {
        if ("OFF".equalsIgnoreCase(logLevel) || "SEVERE".equalsIgnoreCase(logLevel) || "WARNING".equalsIgnoreCase(logLevel) || "INFO".equalsIgnoreCase(logLevel) || "CONFIG".equalsIgnoreCase(logLevel) || "FINE".equalsIgnoreCase(logLevel) || "FINER".equalsIgnoreCase(logLevel) || "FINEST".equalsIgnoreCase(logLevel) || "ALL".equalsIgnoreCase(logLevel)) {
            this.logLevel = logLevel.toUpperCase();
        } else {
            this.getLog().error((CharSequence)("Unknown log level: " + logLevel + " default LogLevel is used."));
        }
    }

    private List<URL> buildClassPath() throws MalformedURLException {
        ArrayList<URL> urls = new ArrayList<URL>();
        if (this.project == null) {
            this.getLog().error((CharSequence)"MavenProject is empty, unable to build ClassPath. No Models can be woven.");
        } else {
            Set artifacts = this.project.getArtifacts();
            for (Artifact a : artifacts) {
                urls.add(a.getFile().toURI().toURL());
            }
        }
        return urls;
    }

    private int getLogLevel() {
        return AbstractSessionLog.translateStringToLoggingLevel((String)this.logLevel);
    }
}

