/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.server.services;

import de.codecentric.boot.admin.server.domain.entities.Instance;
import de.codecentric.boot.admin.server.domain.entities.InstanceRepository;
import de.codecentric.boot.admin.server.domain.values.InstanceId;
import de.codecentric.boot.admin.server.domain.values.Registration;
import de.codecentric.boot.admin.server.services.InstanceIdGenerator;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class InstanceRegistry {
    private final InstanceRepository repository;
    private final InstanceIdGenerator generator;

    public InstanceRegistry(InstanceRepository repository, InstanceIdGenerator generator) {
        this.repository = repository;
        this.generator = generator;
    }

    public Mono<InstanceId> register(Registration registration) {
        Assert.notNull((Object)registration, (String)"'registration' must not be null");
        InstanceId id = this.generator.generateId(registration);
        Assert.notNull((Object)id, (String)"'id' must not be null");
        return this.repository.compute(id, (key, instance) -> {
            if (instance == null) {
                instance = Instance.create(key);
            }
            return Mono.just((Object)instance.register(registration));
        }).map(Instance::getId);
    }

    public Flux<Instance> getInstances() {
        return this.repository.findAll();
    }

    public Flux<Instance> getInstances(String name) {
        return this.repository.findByName(name);
    }

    public Mono<Instance> getInstance(InstanceId id) {
        return this.repository.find(id);
    }

    public Mono<InstanceId> deregister(InstanceId id) {
        return this.repository.computeIfPresent(id, (key, instance) -> Mono.just((Object)instance.deregister())).map(Instance::getId);
    }
}

