/*
 * Decompiled with CFR 0.152.
 */
package de.bwaldvogel.mongo.backend.memory;

import de.bwaldvogel.mongo.MongoDatabase;
import de.bwaldvogel.mongo.backend.AbstractSynchronizedMongoCollection;
import de.bwaldvogel.mongo.backend.CollectionOptions;
import de.bwaldvogel.mongo.backend.CursorRegistry;
import de.bwaldvogel.mongo.backend.DocumentWithPosition;
import de.bwaldvogel.mongo.backend.QueryResult;
import de.bwaldvogel.mongo.backend.memory.DocumentIterable;
import de.bwaldvogel.mongo.bson.Document;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class MemoryCollection
extends AbstractSynchronizedMongoCollection<Integer> {
    private final List<Document> documents = new ArrayList<Document>();
    private final Queue<Integer> emptyPositions = new LinkedList<Integer>();
    private final AtomicInteger dataSize = new AtomicInteger();

    public MemoryCollection(MongoDatabase database, String collectionName, CollectionOptions options, CursorRegistry cursorRegistry) {
        super(database, collectionName, options, cursorRegistry);
    }

    protected void updateDataSize(int sizeDelta) {
        this.dataSize.addAndGet(sizeDelta);
    }

    protected int getDataSize() {
        return this.dataSize.get();
    }

    protected Integer addDocumentInternal(Document document) {
        Integer position = this.emptyPositions.poll();
        if (position == null) {
            position = this.documents.size();
        }
        if (position.intValue() == this.documents.size()) {
            this.documents.add(document);
        } else {
            this.documents.set(position, document);
        }
        return position;
    }

    protected QueryResult matchDocuments(Document query, Document orderBy, int numberToSkip, int limit, int batchSize, Document fieldSelector) {
        Iterable<Document> documents = this.iterateAllDocuments(orderBy);
        Stream<Document> documentStream = StreamSupport.stream(documents.spliterator(), false);
        return this.matchDocumentsFromStream(documentStream, query, orderBy, numberToSkip, limit, batchSize, fieldSelector);
    }

    private Iterable<Document> iterateAllDocuments(Document orderBy) {
        DocumentIterable documentIterable = new DocumentIterable(this.documents);
        if (MemoryCollection.isNaturalDescending((Document)orderBy)) {
            return documentIterable.reversed();
        }
        return documentIterable;
    }

    public synchronized int count() {
        return this.documents.size() - this.emptyPositions.size();
    }

    public synchronized boolean isEmpty() {
        return this.documents.isEmpty() || super.isEmpty();
    }

    protected Integer findDocumentPosition(Document document) {
        int position = this.documents.indexOf(document);
        if (position < 0) {
            return null;
        }
        return position;
    }

    protected Stream<DocumentWithPosition<Integer>> streamAllDocumentsWithPosition() {
        return IntStream.range(0, this.documents.size()).filter(position -> !this.emptyPositions.contains(position)).mapToObj(index -> new DocumentWithPosition(this.documents.get(index), (Object)index));
    }

    protected void removeDocument(Integer position) {
        this.documents.set(position, null);
        this.emptyPositions.add(position);
    }

    protected Document getDocument(Integer position) {
        return this.documents.get(position);
    }

    protected void handleUpdate(Integer position, Document oldDocument, Document newDocument) {
    }
}

