/*
 * Decompiled with CFR 0.152.
 */
package de.bwaldvogel.mongo.backend.memory;

import de.bwaldvogel.mongo.bson.Document;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

class DocumentIterable
implements Iterable<Document> {
    private final List<Document> documents;
    private final boolean reversed;

    DocumentIterable(List<Document> documents) {
        this(documents, false);
    }

    private DocumentIterable(List<Document> documents, boolean reversed) {
        this.documents = documents;
        this.reversed = reversed;
    }

    DocumentIterable reversed() {
        return new DocumentIterable(this.documents, !this.reversed);
    }

    @Override
    public Iterator<Document> iterator() {
        if (!this.reversed) {
            return new DocumentIterator(this.documents);
        }
        return new ReverseDocumentIterator(this.documents);
    }

    private static class DocumentIterator
    extends AbstractDocumentIterator {
        private DocumentIterator(List<Document> documents) {
            super(documents, 0);
        }

        @Override
        protected Document getNext() {
            while (this.pos < this.documents.size()) {
                Document document;
                if ((document = (Document)this.documents.get(this.pos++)) == null) continue;
                return document;
            }
            return null;
        }
    }

    private static class ReverseDocumentIterator
    extends AbstractDocumentIterator {
        private ReverseDocumentIterator(List<Document> documents) {
            super(documents, documents.size() - 1);
        }

        @Override
        protected Document getNext() {
            while (this.pos >= 0) {
                Document document;
                if ((document = (Document)this.documents.get(this.pos--)) == null) continue;
                return document;
            }
            return null;
        }
    }

    private static abstract class AbstractDocumentIterator
    implements Iterator<Document> {
        int pos;
        final List<Document> documents;
        Document current;

        AbstractDocumentIterator(List<Document> documents, int pos) {
            this.documents = documents;
            this.pos = pos;
        }

        protected abstract Document getNext();

        @Override
        public boolean hasNext() {
            if (this.current == null) {
                this.current = this.getNext();
            }
            return this.current != null;
        }

        @Override
        public Document next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Document document = this.current;
            this.current = this.getNext();
            return document;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

