/*
 * Decompiled with CFR 0.152.
 */
package de.bwaldvogel.mongo.backend.aggregation.stage;

import de.bwaldvogel.mongo.MongoCollection;
import de.bwaldvogel.mongo.MongoDatabase;
import de.bwaldvogel.mongo.backend.DatabaseResolver;
import de.bwaldvogel.mongo.backend.aggregation.Aggregation;
import de.bwaldvogel.mongo.backend.aggregation.Expression;
import de.bwaldvogel.mongo.backend.aggregation.stage.AbstractLookupStage;
import de.bwaldvogel.mongo.bson.Document;
import de.bwaldvogel.mongo.oplog.Oplog;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;

public class LookupWithPipelineStage
extends AbstractLookupStage {
    private static final String LET_FIELD = "let";
    public static final String PIPELINE_FIELD = "pipeline";
    private static final Set<String> CONFIGURATION_KEYS = new HashSet<String>();
    private final MongoDatabase mongoDatabase;
    private final DatabaseResolver databaseResolver;
    private final Oplog oplog;
    private final MongoCollection<?> collection;
    private final Document let;
    private final Object pipeline;
    private final String as;

    public LookupWithPipelineStage(Document configuration, MongoDatabase mongoDatabase, DatabaseResolver databaseResolver, Oplog oplog) {
        this.mongoDatabase = mongoDatabase;
        this.databaseResolver = databaseResolver;
        this.oplog = oplog;
        String from = this.readStringConfigurationProperty(configuration, "from");
        this.collection = mongoDatabase.resolveCollection(from, false);
        this.let = this.readOptionalDocumentArgument(configuration, LET_FIELD);
        this.pipeline = configuration.get(PIPELINE_FIELD);
        this.as = this.readStringConfigurationProperty(configuration, "as");
        this.ensureAllConfigurationPropertiesAreKnown(configuration, CONFIGURATION_KEYS);
    }

    @Override
    public Stream<Document> apply(Stream<Document> stream) {
        return stream.map(this::joinDocuments);
    }

    private Document joinDocuments(Document document) {
        Aggregation aggregation = Aggregation.fromPipeline(this.pipeline, this.databaseResolver, this.mongoDatabase, this.collection, this.oplog);
        aggregation.setVariables(this.evaluateVariables(document));
        List<Document> documents = aggregation.computeResult();
        Document result = document.clone();
        result.put(this.as, (Object)documents);
        return result;
    }

    private Map<String, Object> evaluateVariables(Document document) {
        Document variables = new Document();
        for (Map.Entry<String, Object> entry : this.let.entrySet()) {
            Object expression = entry.getValue();
            Object value = Expression.evaluateDocument(expression, document);
            variables.put("$" + entry.getKey(), value);
        }
        return variables;
    }

    static {
        CONFIGURATION_KEYS.add("from");
        CONFIGURATION_KEYS.add(LET_FIELD);
        CONFIGURATION_KEYS.add(PIPELINE_FIELD);
        CONFIGURATION_KEYS.add("as");
    }
}

