/*
 * Decompiled with CFR 0.152.
 */
package de.bwaldvogel.mongo.backend;

import de.bwaldvogel.mongo.bson.Decimal128;
import java.math.BigDecimal;

public class NumericUtils {
    private static Number calculate(Number a, Number b, LongCalculation longCalculation, DoubleCalculation doubleCalculation, BigDecimalCalculation bigDecimalCalculation) {
        if (a instanceof Decimal128 || b instanceof Decimal128) {
            BigDecimal result = bigDecimalCalculation.apply(NumericUtils.toBigDecimal(a), NumericUtils.toBigDecimal(b));
            return new Decimal128(result);
        }
        if (a instanceof Double || b instanceof Double) {
            return doubleCalculation.apply(a.doubleValue(), b.doubleValue());
        }
        if (a instanceof Float || b instanceof Float) {
            double result = doubleCalculation.apply(a.doubleValue(), b.doubleValue());
            return Float.valueOf((float)result);
        }
        if (a instanceof Long || b instanceof Long) {
            return longCalculation.apply(a.longValue(), b.longValue());
        }
        if (a instanceof Integer || b instanceof Integer) {
            long result = longCalculation.apply(a.longValue(), b.longValue());
            int intResult = (int)result;
            if ((long)intResult == result) {
                return intResult;
            }
            return result;
        }
        if (a instanceof Short || b instanceof Short) {
            long result = longCalculation.apply(a.longValue(), b.longValue());
            short shortResult = (short)result;
            if ((long)shortResult == result) {
                return shortResult;
            }
            return result;
        }
        throw new UnsupportedOperationException("cannot calculate on " + a + " and " + b);
    }

    private static BigDecimal toBigDecimal(Number value) {
        return Decimal128.fromNumber(value).toBigDecimal();
    }

    public static Number addNumbers(Number one, Number other) {
        return NumericUtils.calculate(one, other, Long::sum, Double::sum, BigDecimal::add);
    }

    public static Number subtractNumbers(Number one, Number other) {
        return NumericUtils.calculate(one, other, (a, b) -> a - b, (a, b) -> a - b, BigDecimal::subtract);
    }

    public static Number multiplyNumbers(Number one, Number other) {
        return NumericUtils.calculate(one, other, (a, b) -> a * b, (a, b) -> a * b, BigDecimal::multiply);
    }

    @FunctionalInterface
    public static interface BigDecimalCalculation {
        public BigDecimal apply(BigDecimal var1, BigDecimal var2);
    }

    @FunctionalInterface
    public static interface DoubleCalculation {
        public double apply(double var1, double var3);
    }

    @FunctionalInterface
    public static interface LongCalculation {
        public long apply(long var1, long var3);
    }
}

