/*
 * Decompiled with CFR 0.152.
 */
package de.bwaldvogel.mongo.wire;

import de.bwaldvogel.mongo.backend.Assert;
import de.bwaldvogel.mongo.bson.Document;
import de.bwaldvogel.mongo.wire.BsonDecoder;
import de.bwaldvogel.mongo.wire.OpCode;
import de.bwaldvogel.mongo.wire.QueryFlag;
import de.bwaldvogel.mongo.wire.UpdateFlag;
import de.bwaldvogel.mongo.wire.message.ClientRequest;
import de.bwaldvogel.mongo.wire.message.MessageHeader;
import de.bwaldvogel.mongo.wire.message.MongoDelete;
import de.bwaldvogel.mongo.wire.message.MongoInsert;
import de.bwaldvogel.mongo.wire.message.MongoQuery;
import de.bwaldvogel.mongo.wire.message.MongoUpdate;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import java.io.IOException;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoWireProtocolHandler
extends LengthFieldBasedFrameDecoder {
    public static final int MAX_MESSAGE_SIZE_BYTES = 48000000;
    public static final int MAX_WRITE_BATCH_SIZE = 1000;
    private static final Logger log = LoggerFactory.getLogger(MongoWireProtocolHandler.class);
    private static final int maxFrameLength = Integer.MAX_VALUE;
    private static final int lengthFieldOffset = 0;
    private static final int lengthFieldLength = 4;
    private static final int lengthAdjustment = -4;
    private static final int initialBytesToStrip = 0;
    private final BsonDecoder bsonDecoder = new BsonDecoder();

    public MongoWireProtocolHandler() {
        super(Integer.MAX_VALUE, 0, 4, -4, 0);
    }

    protected ClientRequest decode(ChannelHandlerContext ctx, ByteBuf buf) throws Exception {
        ClientRequest request;
        ByteBuf in = buf;
        if (in.readableBytes() < 4) {
            return null;
        }
        in.markReaderIndex();
        int totalLength = in.readIntLE();
        if (totalLength > 48000000) {
            throw new IOException("message too large: " + totalLength + " bytes");
        }
        if (in.readableBytes() < totalLength - 4) {
            in.resetReaderIndex();
            return null;
        }
        in = in.readSlice(totalLength - 4);
        int readable = in.readableBytes();
        Assert.equals(readable, totalLength - 4);
        int requestID = in.readIntLE();
        int responseTo = in.readIntLE();
        MessageHeader header = new MessageHeader(requestID, responseTo);
        int opCodeId = in.readIntLE();
        OpCode opCode = OpCode.getById(opCodeId);
        if (opCode == null) {
            throw new IOException("opCode " + opCodeId + " not supported");
        }
        Channel channel = ctx.channel();
        switch (opCode) {
            case OP_QUERY: {
                request = this.handleQuery(channel, header, in);
                break;
            }
            case OP_INSERT: {
                request = this.handleInsert(channel, header, in);
                break;
            }
            case OP_DELETE: {
                request = this.handleDelete(channel, header, in);
                break;
            }
            case OP_UPDATE: {
                request = this.handleUpdate(channel, header, in);
                break;
            }
            default: {
                throw new UnsupportedOperationException("unsupported opcode: " + (Object)((Object)opCode));
            }
        }
        if (in.isReadable()) {
            throw new IOException();
        }
        log.debug("{}", (Object)request);
        return request;
    }

    private ClientRequest handleDelete(Channel channel, MessageHeader header, ByteBuf buffer) throws IOException {
        buffer.skipBytes(4);
        String fullCollectionName = this.bsonDecoder.decodeCString(buffer);
        int flags = buffer.readIntLE();
        boolean singleRemove = false;
        if (flags != 0) {
            if (flags == 1) {
                singleRemove = true;
            } else {
                throw new UnsupportedOperationException("flags=" + flags + " not yet supported");
            }
        }
        Document selector = this.bsonDecoder.decodeBson(buffer);
        log.debug("delete {} from {}", (Object)selector, (Object)fullCollectionName);
        return new MongoDelete(channel, header, fullCollectionName, selector, singleRemove);
    }

    private ClientRequest handleUpdate(Channel channel, MessageHeader header, ByteBuf buffer) throws IOException {
        buffer.skipBytes(4);
        String fullCollectionName = this.bsonDecoder.decodeCString(buffer);
        int flags = buffer.readIntLE();
        boolean upsert = UpdateFlag.UPSERT.isSet(flags);
        boolean multi = UpdateFlag.MULTI_UPDATE.isSet(flags);
        Document selector = this.bsonDecoder.decodeBson(buffer);
        Document update = this.bsonDecoder.decodeBson(buffer);
        log.debug("update {} in {}", (Object)selector, (Object)fullCollectionName);
        return new MongoUpdate(channel, header, fullCollectionName, selector, update, upsert, multi);
    }

    private ClientRequest handleInsert(Channel channel, MessageHeader header, ByteBuf buffer) throws IOException {
        int flags = buffer.readIntLE();
        if (flags != 0) {
            throw new UnsupportedOperationException("flags=" + flags + " not yet supported");
        }
        String fullCollectionName = this.bsonDecoder.decodeCString(buffer);
        ArrayList<Document> documents = new ArrayList<Document>();
        while (buffer.isReadable()) {
            Document document = this.bsonDecoder.decodeBson(buffer);
            documents.add(document);
        }
        log.debug("insert {} in {}", documents, (Object)fullCollectionName);
        return new MongoInsert(channel, header, fullCollectionName, documents);
    }

    private ClientRequest handleQuery(Channel channel, MessageHeader header, ByteBuf buffer) throws IOException {
        int flags = buffer.readIntLE();
        String fullCollectionName = this.bsonDecoder.decodeCString(buffer);
        int numberToSkip = buffer.readIntLE();
        int numberToReturn = buffer.readIntLE();
        Document query = this.bsonDecoder.decodeBson(buffer);
        Document returnFieldSelector = null;
        if (buffer.isReadable()) {
            returnFieldSelector = this.bsonDecoder.decodeBson(buffer);
        }
        MongoQuery mongoQuery = new MongoQuery(channel, header, fullCollectionName, numberToSkip, numberToReturn, query, returnFieldSelector);
        if (QueryFlag.SLAVE_OK.isSet(flags)) {
            flags = QueryFlag.SLAVE_OK.removeFrom(flags);
        }
        if (QueryFlag.NO_CURSOR_TIMEOUT.isSet(flags)) {
            flags = QueryFlag.NO_CURSOR_TIMEOUT.removeFrom(flags);
        }
        if (flags != 0) {
            throw new UnsupportedOperationException("flags=" + flags + " not yet supported");
        }
        log.debug("query {} from {}", (Object)query, (Object)fullCollectionName);
        return mongoQuery;
    }
}

