/*
 * Decompiled with CFR 0.152.
 */
package de.bwaldvogel.mongo.backend.aggregation.stage;

import de.bwaldvogel.mongo.backend.Missing;
import de.bwaldvogel.mongo.backend.Utils;
import de.bwaldvogel.mongo.backend.aggregation.Expression;
import de.bwaldvogel.mongo.backend.aggregation.stage.AggregationStage;
import de.bwaldvogel.mongo.bson.Document;
import de.bwaldvogel.mongo.exception.MongoServerError;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Stream;

public class ProjectStage
implements AggregationStage {
    private final Document projection;
    private final boolean hasInclusions;

    public ProjectStage(Document projection) {
        if (projection.isEmpty()) {
            throw new MongoServerError(40177, "Invalid $project :: caused by :: specification must have at least one field");
        }
        this.projection = projection;
        this.hasInclusions = ProjectStage.hasInclusions(projection);
    }

    private static boolean hasInclusions(Document projection) {
        for (Map.Entry<String, Object> entry : projection.entrySet()) {
            Object projectionValue = entry.getValue();
            if (!Utils.isTrue(projectionValue)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Stream<Document> apply(Stream<Document> stream) {
        return stream.map(this::projectDocument);
    }

    Document projectDocument(Document document) {
        Document result = new Document();
        if (!this.projection.containsKey("_id")) {
            ProjectStage.putIfContainsField(document, result, "_id");
        }
        Map<String, Object> effectiveProjection = this.calculateEffectiveProjection(document);
        for (Map.Entry<String, Object> entry : effectiveProjection.entrySet()) {
            String field = entry.getKey();
            Object projectionValue = entry.getValue();
            if (projectionValue instanceof Number || projectionValue instanceof Boolean) {
                if (!Utils.isTrue(projectionValue)) continue;
                ProjectStage.putIfContainsField(document, result, field);
                continue;
            }
            if (projectionValue == null) {
                result.put(field, (Object)null);
                continue;
            }
            Object value = Expression.evaluateDocument(projectionValue, document);
            if (value instanceof Missing) continue;
            result.put(field, value);
        }
        return result;
    }

    private Map<String, Object> calculateEffectiveProjection(Document document) {
        if (this.hasInclusions) {
            return this.projection;
        }
        LinkedHashMap<String, Object> effectiveProjection = new LinkedHashMap<String, Object>(this.projection);
        for (String documentField : document.keySet()) {
            if (effectiveProjection.containsKey(documentField)) continue;
            effectiveProjection.put(documentField, Boolean.TRUE);
        }
        return effectiveProjection;
    }

    private static void putIfContainsField(Document input, Document result, String field) {
        if (input.containsKey(field)) {
            result.put(field, input.get(field));
        }
    }
}

