/*
 * Decompiled with CFR 0.152.
 */
package de.bwaldvogel.mongo.bson;

import de.bwaldvogel.mongo.backend.Missing;
import de.bwaldvogel.mongo.bson.Document;
import de.bwaldvogel.mongo.bson.ObjectId;
import java.util.Collection;
import java.util.Date;
import java.util.stream.Collectors;

public final class Json {
    private Json() {
    }

    public static String toJsonValue(Object value) {
        return Json.toJsonValue(value, false, "{", "}");
    }

    public static String toJsonValue(Object value, boolean compactKey, String jsonPrefix, String jsonSuffix) {
        if (Missing.isNullOrMissing(value)) {
            return "null";
        }
        if (value instanceof Number) {
            return value.toString();
        }
        if (value instanceof Boolean) {
            return value.toString();
        }
        if (value instanceof String) {
            return "\"" + Json.escapeJson((String)value) + "\"";
        }
        if (value instanceof Document) {
            Document document = (Document)value;
            return document.toString(compactKey, jsonPrefix, jsonSuffix);
        }
        if (value instanceof Date) {
            Date date = (Date)value;
            return Json.toJsonValue(date.toInstant().toString());
        }
        if (value instanceof Collection) {
            Collection collection = (Collection)value;
            return collection.stream().map(Json::toJsonValue).collect(Collectors.joining(", ", "[", "]"));
        }
        if (value instanceof ObjectId) {
            ObjectId objectId = (ObjectId)value;
            return objectId.getHexData();
        }
        return Json.toJsonValue(value.toString());
    }

    static String escapeJson(String input) {
        String escaped = input;
        escaped = escaped.replace("\\", "\\\\");
        escaped = escaped.replace("\"", "\\\"");
        escaped = escaped.replace("\b", "\\b");
        escaped = escaped.replace("\f", "\\f");
        escaped = escaped.replace("\n", "\\n");
        escaped = escaped.replace("\r", "\\r");
        escaped = escaped.replace("\t", "\\t");
        return escaped;
    }
}

