/*
 * Decompiled with CFR 0.152.
 */
package de.bitgrip.ficum.visitor;

import java.util.regex.Pattern;

public class Wildcards {
    private static final Pattern SPECIAL_REGEX_CHARS = Pattern.compile("[{}()\\[\\].+^$\\\\|]");

    private Wildcards() {
    }

    public static String escapeAndConvertToRegexWildcards(String value, boolean alwaysWildcard) {
        String ret = SPECIAL_REGEX_CHARS.matcher(value).replaceAll("\\\\$0").replaceAll("\\*", ".*").replaceAll("\\?", ".?");
        return alwaysWildcard ? ".*" + ret + ".*" : "^" + ret + "$";
    }

    public static String escapeAndConvertToSQLWildcards(String value, boolean alwaysWildcard) {
        String ret = value.replaceAll("\\\\", "\\\\\\\\").replaceAll("_", "\\\\_").replaceAll("%", "\\\\%").replaceAll("\\*", "%").replaceAll("\\?", "_");
        return alwaysWildcard ? "%" + ret + "%" : ret;
    }
}

