/*
 * Decompiled with CFR 0.152.
 */
package de.bitgrip.ficum.node;

import de.bitgrip.ficum.node.Comparison;
import de.bitgrip.ficum.node.Selector;

public class Constraint<T> {
    private String selector;
    private Comparison comparison;
    private T argument;

    public Constraint(String selector, Comparison comparison, T argument) {
        Constraint.checkArgNotNull(comparison, "comparison");
        Constraint.checkArgNotNull(selector, "selector");
        this.selector = selector;
        this.comparison = comparison;
        this.argument = argument;
    }

    public Constraint(Selector selector, Comparison comparison, T argument) {
        this(Constraint.checkArgNotNull(selector, "selector").getValue(), comparison, argument);
    }

    public static <T> T checkArgNotNull(T reference, String parameterName) {
        if (reference == null) {
            throw new IllegalArgumentException(String.format("'%s' must not be null", parameterName));
        }
        return reference;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Constraint)) {
            return false;
        }
        Constraint other = (Constraint)obj;
        if (this.argument == null ? other.argument != null : !this.argument.equals(other.argument)) {
            return false;
        }
        if (this.comparison != other.comparison) {
            return false;
        }
        return !(this.selector == null ? other.selector != null : !this.selector.equals(other.selector));
    }

    public T getArgument() {
        return this.argument;
    }

    public Comparison getComparison() {
        return this.comparison;
    }

    public String getSelector() {
        return this.selector;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.argument == null ? 0 : this.argument.hashCode());
        result = 31 * result + (this.comparison == null ? 0 : this.comparison.hashCode());
        result = 31 * result + (this.selector == null ? 0 : this.selector.hashCode());
        return result;
    }

    public String toString() {
        return String.format("'%s%s(%s)%s'", this.selector, this.comparison.getSign(), this.argument == null ? "null" : this.argument.getClass().getSimpleName(), this.argument);
    }
}

