/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.webjars.request;

import de.agilecoders.wicket.webjars.request.resource.IWebjarsResourceReference;
import java.util.List;
import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.request.IRequestMapper;
import org.apache.wicket.request.Request;
import org.apache.wicket.request.Url;
import org.apache.wicket.request.handler.resource.ResourceReferenceRequestHandler;
import org.apache.wicket.request.mapper.parameter.INamedParameters;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.request.resource.caching.IResourceCachingStrategy;
import org.apache.wicket.request.resource.caching.ResourceUrl;
import org.apache.wicket.util.IProvider;
import org.apache.wicket.util.string.Strings;

public class WebjarsCDNRequestMapper
implements IRequestMapper {
    private final IRequestMapper chain;
    private final String webJarCdnUrl;
    private final IProvider<IResourceCachingStrategy> cachingStrategyProvider;

    public WebjarsCDNRequestMapper(IRequestMapper chain, String cdnUrl, IProvider<IResourceCachingStrategy> cachingStrategyProvider) {
        this.chain = chain;
        this.webJarCdnUrl = cdnUrl;
        this.cachingStrategyProvider = cachingStrategyProvider;
    }

    public Url mapHandler(IRequestHandler requestHandler) {
        if (WebjarsCDNRequestMapper.isWebjarsResourceReference(requestHandler)) {
            Url url = this.chain.mapHandler(requestHandler);
            String urlString = this.urlToStringWithNoVersion(url);
            int index = urlString.indexOf("/webjars/");
            if (index >= 0) {
                return Url.parse((CharSequence)Strings.join((String)"/", (String[])new String[]{this.webJarCdnUrl, urlString.substring(index + "/webjars/".length())}));
            }
            return url;
        }
        return null;
    }

    private static boolean isWebjarsResourceReference(IRequestHandler requestHandler) {
        ResourceReferenceRequestHandler resourceReferenceRequestHandler;
        ResourceReference resourceReference;
        return requestHandler instanceof ResourceReferenceRequestHandler && (resourceReference = (resourceReferenceRequestHandler = (ResourceReferenceRequestHandler)requestHandler).getResourceReference()) instanceof IWebjarsResourceReference;
    }

    public IRequestHandler mapRequest(Request request) {
        return null;
    }

    public int getCompatibilityScore(Request request) {
        return 0;
    }

    private String urlToStringWithNoVersion(Url url) {
        int lastSegmentIndex;
        String filename;
        Url copy = new Url(url);
        List segments = copy.getSegments();
        if (!segments.isEmpty() && !Strings.isEmpty((CharSequence)(filename = (String)segments.get(lastSegmentIndex = segments.size() - 1)))) {
            ResourceUrl resourceUrl = new ResourceUrl(filename, (INamedParameters)new PageParameters());
            ((IResourceCachingStrategy)this.cachingStrategyProvider.get()).undecorateUrl(resourceUrl);
            if (Strings.isEmpty((CharSequence)resourceUrl.getFileName())) {
                throw new IllegalStateException("caching strategy returned empty name for " + resourceUrl);
            }
            segments.set(lastSegmentIndex, resourceUrl.getFileName());
        }
        return copy.toString();
    }
}

