/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.jquery.function;

import de.agilecoders.wicket.jquery.function.IFunction;
import de.agilecoders.wicket.jquery.function.JavaScriptInlineFunction;
import de.agilecoders.wicket.jquery.util.CharSequenceWrapper;
import de.agilecoders.wicket.jquery.util.Generics2;
import java.util.List;
import org.apache.wicket.util.lang.Args;

public abstract class AbstractFunction
implements IFunction {
    private final CharSequence functionName;
    private final List<CharSequence> parameters;

    protected AbstractFunction(CharSequence functionName) {
        this(functionName, Generics2.newArrayList(new CharSequence[0]));
    }

    protected AbstractFunction(CharSequence functionName, List<CharSequence> parameters) {
        this.functionName = Args.notEmpty((CharSequence)functionName, (String)"functionName");
        this.parameters = parameters;
    }

    @Override
    public String build() {
        return this.functionName + "(" + this.buildParameters() + ")";
    }

    protected final char getSeparator() {
        return ',';
    }

    protected String buildParameters() {
        return Generics2.join(this.parameters, this.getSeparator());
    }

    protected void addParameter(CharSequence parameter) {
        this.parameters.add(parameter);
    }

    protected CharSequence toParameterValue(Object value) {
        return CharSequenceWrapper.toParameterValue(value);
    }

    protected CharSequence toParameterValue(JavaScriptInlineFunction value) {
        return CharSequenceWrapper.toParameterValue(value);
    }

    protected CharSequence toParameterValue(Long value) {
        return CharSequenceWrapper.toParameterValue(value);
    }

    protected CharSequence toParameterValue(Integer value) {
        return CharSequenceWrapper.toParameterValue(value);
    }

    protected CharSequence toParameterValue(Float value) {
        return CharSequenceWrapper.toParameterValue(value);
    }

    protected CharSequence toParameterValue(Boolean value) {
        return CharSequenceWrapper.toParameterValue(value);
    }

    public List<CharSequence> getParameters() {
        return this.parameters;
    }
}

