/*
 * Decompiled with CFR 0.152.
 */
package com.zebrunner.carina.crypto;

import com.zebrunner.carina.crypto.Algorithm;
import com.zebrunner.carina.crypto.CryptoTool;
import com.zebrunner.carina.crypto.CryptoToolImpl;
import java.lang.invoke.MethodHandles;
import java.security.Key;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CryptoToolBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private Key key;
    private String keyAsString = "";
    private Algorithm algorithm;

    private CryptoToolBuilder() {
    }

    public static CryptoToolBuilder builder() {
        return new CryptoToolBuilder();
    }

    public CryptoToolBuilder chooseAlgorithm(Algorithm algorithm) {
        this.algorithm = algorithm;
        return this;
    }

    public CryptoToolBuilder setKey(Key key) {
        this.key = key;
        return this;
    }

    public CryptoToolBuilder setKey(String key) {
        this.keyAsString = key;
        return this;
    }

    public CryptoTool build() {
        this.validate();
        if (this.key != null) {
            if (!this.keyAsString.isEmpty()) {
                LOGGER.warn("Key as object has high priority over key as string. Choose one of the key transfer methods");
            }
            return new CryptoToolImpl(this.algorithm, this.key);
        }
        return new CryptoToolImpl(this.algorithm, this.keyAsString);
    }

    private void validate() {
        if (this.key == null && (this.keyAsString == null || this.keyAsString.isEmpty())) {
            throw new IllegalArgumentException("The key must be passed!");
        }
        if (this.algorithm == null) {
            throw new IllegalArgumentException("The algorithm must be chosen!");
        }
    }
}

