/*
 * Decompiled with CFR 0.152.
 */
package com.zebrunner.agent.testng.listener;

import com.zebrunner.agent.testng.adapter.TestNGAdapter;
import com.zebrunner.agent.testng.listener.RerunAwareListener;
import com.zebrunner.agent.testng.listener.RetryService;
import com.zebrunner.agent.testng.listener.RunContextService;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.IConfigurationListener;
import org.testng.ISuite;
import org.testng.ISuiteListener;
import org.testng.ITestContext;
import org.testng.ITestListener;
import org.testng.ITestNGListener;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;
import org.testng.internal.ConfigurationMethod;

public class TestRunListener
extends RerunAwareListener
implements ISuiteListener,
ITestListener,
ITestNGListener,
IConfigurationListener {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final TestNGAdapter adapter = new TestNGAdapter();

    public void onStart(ISuite suite) {
        log.debug("Beginning TestRunListener -> onStart(ISuite suite)");
        this.adapter.registerRunStart(suite);
        log.debug("Finishing TestRunListener -> onStart(ISuite suite)");
    }

    public void onFinish(ISuite suite) {
        log.debug("Beginning TestRunListener -> onFinish(ISuite suite)");
        this.adapter.registerRunFinish(suite);
        log.debug("Finishing TestRunListener -> onFinish(ISuite suite)");
    }

    public void onTestStart(ITestResult testResult) {
        log.debug("Beginning TestRunListener -> onTestStart");
        if (RetryService.isRetryFinished(testResult.getMethod(), testResult.getTestContext())) {
            RunContextService.incrementMethodInvocationIndex(testResult.getMethod(), testResult.getTestContext());
        }
        this.adapter.registerTestStart(testResult);
        log.debug("Finishing TestRunListener -> onTestStart");
    }

    public void onTestSuccess(ITestResult testResult) {
        log.debug("Beginning TestRunListener -> onTestSuccess");
        this.adapter.registerTestFinish(testResult);
        log.debug("Finishing TestRunListener -> onTestSuccess");
    }

    public void onTestFailure(ITestResult testResult) {
        log.debug("Beginning TestRunListener -> onTestFailure");
        this.adapter.registerFailedTestFinish(testResult);
        log.debug("Finishing TestRunListener -> onTestFailure");
    }

    public void onTestSkipped(ITestResult testResult) {
        log.debug("Beginning TestRunListener -> onTestSkipped");
        this.adapter.registerSkippedTestFinish(testResult);
        log.debug("Finishing TestRunListener -> onTestSkipped");
    }

    public void onTestFailedButWithinSuccessPercentage(ITestResult testResult) {
        log.debug("Beginning TestRunListener -> onTestFailedButWithinSuccessPercentage");
        this.adapter.registerTestFinish(testResult);
        log.debug("Finishing TestRunListener -> onTestFailedButWithinSuccessPercentage");
    }

    public void onStart(ITestContext context) {
    }

    public void onFinish(ITestContext context) {
    }

    public void beforeConfiguration(ITestResult tr, ITestNGMethod tm) {
        ITestNGMethod testMethod = tr.getMethod();
        if (testMethod instanceof ConfigurationMethod) {
            ConfigurationMethod configurationMethod = (ConfigurationMethod)testMethod;
            if (configurationMethod.isBeforeMethodConfiguration()) {
                this.adapter.registerHeadlessTestStart(tr, tm);
            }
            if (configurationMethod.isAfterMethodConfiguration()) {
                this.adapter.registerAfterTestStart();
            }
        }
    }

    public void onConfigurationSuccess(ITestResult tr) {
        this.registerFinishOfAfterMethod(tr);
    }

    public void onConfigurationFailure(ITestResult tr) {
        this.registerFinishOfAfterMethod(tr);
    }

    public void onConfigurationSkip(ITestResult tr) {
        this.registerFinishOfAfterMethod(tr);
    }

    private void registerFinishOfAfterMethod(ITestResult testResult) {
        ConfigurationMethod configurationMethod;
        ITestNGMethod testMethod = testResult.getMethod();
        if (testMethod instanceof ConfigurationMethod && (configurationMethod = (ConfigurationMethod)testMethod).isAfterMethodConfiguration()) {
            this.adapter.registerAfterTestFinish();
        }
    }
}

