/*
 * Decompiled with CFR 0.152.
 */
package com.zebrunner.agent.testng.core.method;

import com.zebrunner.agent.testng.core.FactoryInstanceHolder;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Stack;
import java.util.stream.Collectors;
import org.testng.IMethodInstance;
import org.testng.ITestNGMethod;

public final class DependantMethodResolver {
    public static Set<IMethodInstance> resolve(Collection<IMethodInstance> methodsSuperSet, Collection<IMethodInstance> methods) {
        Map<String, Set<IMethodInstance>> nameToMethods = DependantMethodResolver.collectMethodsByName(methodsSuperSet);
        Set<IMethodInstance> dependantMethods = methods.stream().map(IMethodInstance::getMethod).map(method -> DependantMethodResolver.getDependantMethods(nameToMethods, method)).flatMap(Collection::stream).collect(Collectors.toSet());
        Map<String, Set<IMethodInstance>> groupToMethods = DependantMethodResolver.collectMethodsByDependedGroups(methodsSuperSet);
        Set dependantGroupMethods = methods.stream().map(IMethodInstance::getMethod).map(method -> DependantMethodResolver.getDependantGroupMethods(groupToMethods, method)).flatMap(Collection::stream).collect(Collectors.toSet());
        dependantMethods.addAll(dependantGroupMethods);
        return dependantMethods;
    }

    private static Map<String, Set<IMethodInstance>> collectMethodsByName(Collection<IMethodInstance> methods) {
        return methods.stream().collect(Collectors.groupingBy(instance -> instance.getMethod().getQualifiedName(), Collectors.toSet()));
    }

    private static Map<String, Set<IMethodInstance>> collectMethodsByDependedGroups(Collection<IMethodInstance> methods) {
        HashMap<String, Set<IMethodInstance>> groupToMethods = new HashMap<String, Set<IMethodInstance>>();
        methods.stream().map(IMethodInstance::getMethod).flatMap(method -> Arrays.stream(method.getGroups())).forEach(group -> groupToMethods.put((String)group, new HashSet()));
        methods.forEach(instance -> Arrays.stream(instance.getMethod().getGroups()).map(groupToMethods::get).filter(Objects::nonNull).forEach(groupMethods -> groupMethods.add(instance)));
        return groupToMethods;
    }

    private static Set<IMethodInstance> getDependantMethods(Map<String, Set<IMethodInstance>> methods, ITestNGMethod method) {
        HashSet<String> resolvedMethods = new HashSet<String>();
        HashSet<IMethodInstance> dependantMethods = new HashSet<IMethodInstance>();
        Stack methodsToResolve = new Stack();
        Set nextMethodsToResolveBatch = Arrays.stream(method.getMethodsDependedUpon()).collect(Collectors.toSet());
        methodsToResolve.addAll(nextMethodsToResolveBatch);
        while (!methodsToResolve.isEmpty()) {
            String dependantMethodName = (String)methodsToResolve.pop();
            resolvedMethods.add(dependantMethodName);
            Set methodsWithSameFactoryInstance = methods.getOrDefault(dependantMethodName, Collections.emptySet()).stream().filter(dependantMethod -> DependantMethodResolver.belongsToTheSameFactoryInstance(dependantMethod.getMethod(), method)).collect(Collectors.toSet());
            if (methodsWithSameFactoryInstance.isEmpty()) continue;
            dependantMethods.addAll(methodsWithSameFactoryInstance);
            nextMethodsToResolveBatch = methodsWithSameFactoryInstance.stream().map(IMethodInstance::getMethod).map(ITestNGMethod::getMethodsDependedUpon).flatMap(Arrays::stream).filter(methodName -> !resolvedMethods.contains(methodName)).collect(Collectors.toSet());
            methodsToResolve.addAll(nextMethodsToResolveBatch);
        }
        return dependantMethods;
    }

    private static Set<IMethodInstance> getDependantGroupMethods(Map<String, Set<IMethodInstance>> groups, ITestNGMethod method) {
        HashSet<String> resolvedGroups = new HashSet<String>();
        HashSet<IMethodInstance> dependantMethods = new HashSet<IMethodInstance>();
        Stack groupsToResolve = new Stack();
        Set nextGroupsToResolveBatch = Arrays.stream(method.getGroupsDependedUpon()).collect(Collectors.toSet());
        groupsToResolve.addAll(nextGroupsToResolveBatch);
        while (!groupsToResolve.isEmpty()) {
            String dependantGroup = (String)groupsToResolve.pop();
            resolvedGroups.add(dependantGroup);
            Set methodsWithSameFactoryInstance = groups.getOrDefault(dependantGroup, Collections.emptySet()).stream().filter(dependantMethod -> DependantMethodResolver.belongsToTheSameFactoryInstance(dependantMethod.getMethod(), method)).collect(Collectors.toSet());
            if (methodsWithSameFactoryInstance.isEmpty()) continue;
            dependantMethods.addAll(methodsWithSameFactoryInstance);
            nextGroupsToResolveBatch = methodsWithSameFactoryInstance.stream().map(IMethodInstance::getMethod).map(ITestNGMethod::getGroupsDependedUpon).flatMap(Arrays::stream).filter(group -> !resolvedGroups.contains(group)).collect(Collectors.toSet());
            groupsToResolve.addAll(nextGroupsToResolveBatch);
        }
        return dependantMethods;
    }

    private static boolean belongsToTheSameFactoryInstance(ITestNGMethod method1, ITestNGMethod method2) {
        return FactoryInstanceHolder.getInstanceIndex(method1) == FactoryInstanceHolder.getInstanceIndex(method2);
    }
}

