/*
 * Decompiled with CFR 0.152.
 */
package com.zebrunner.agent.testng.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;

public class TestMethodContext {
    private final ThreadLocal<AtomicInteger> currentInvocationCount = ThreadLocal.withInitial(() -> new AtomicInteger(0));
    private List<Integer> dataProviderIndicesForRerun = Collections.emptyList();
    private List<Object[]> dataProviderData = Collections.emptyList();
    private final ThreadLocal<DataProviderData> currentDataProviderData = new ThreadLocal();
    private final ThreadLocal<Integer> currentDataProviderIteratorIndex = ThreadLocal.withInitial(() -> -1);

    public void setDataProviderIndicesForRerun(Collection<Integer> indicesForRerun) {
        this.dataProviderIndicesForRerun = new ArrayList<Integer>(indicesForRerun);
        Collections.sort(this.dataProviderIndicesForRerun);
    }

    public int getDataProviderSize() {
        return this.dataProviderData.size();
    }

    public void setDataProviderData(List<Object[]> dataProviderData) {
        if (dataProviderData != null) {
            this.dataProviderData = dataProviderData;
        }
    }

    public void setCurrentDataProviderIteratorIndex(int currentDataProviderIteratorIndex) {
        this.currentDataProviderIteratorIndex.set(currentDataProviderIteratorIndex);
    }

    public void setCurrentDataProviderData(Object[] parameters, Integer index) {
        this.currentDataProviderData.set(new DataProviderData(parameters, index));
    }

    public int getCurrentDataProviderIndex(Object[] actualTestParameters) {
        return this.getCurrentDataProviderIteratorIndex().filter(currentIndex -> currentIndex != -1).or(() -> this.getReferenceEqualDataProviderData(actualTestParameters)).or(() -> this.getValueEqualDataProviderData(actualTestParameters)).or(() -> this.getStringSameDataProviderData(actualTestParameters)).or(() -> this.getIndexOfMatchingDataProviderData(actualTestParameters)).orElse(-1);
    }

    public Optional<Integer> getCurrentDataProviderIteratorIndex() {
        Integer currentIndex = this.currentDataProviderIteratorIndex.get();
        return currentIndex > -1 && this.dataProviderIndicesForRerun.size() > currentIndex ? Optional.ofNullable(this.dataProviderIndicesForRerun.get(currentIndex)) : Optional.of(currentIndex);
    }

    public Optional<Integer> getReferenceEqualDataProviderData(Object[] data) {
        for (int i = 0; i < this.dataProviderData.size(); ++i) {
            if (this.dataProviderData.get(i) != data) continue;
            return Optional.of(i);
        }
        return Optional.empty();
    }

    public Optional<Integer> getValueEqualDataProviderData(Object[] data) {
        List<Object> dataAsList = Arrays.asList(data);
        for (int i = 0; i < this.dataProviderData.size(); ++i) {
            List<Object> dataProviderLineAsList = Arrays.asList(this.dataProviderData.get(i));
            if (!dataProviderLineAsList.equals(dataAsList)) continue;
            return Optional.of(i);
        }
        return Optional.empty();
    }

    public Optional<Integer> getStringSameDataProviderData(Object[] data) {
        List<String> dataAsList = this.toStringsList(data);
        for (int i = 0; i < this.dataProviderData.size(); ++i) {
            List<String> dataProviderLineAsList = this.toStringsList(this.dataProviderData.get(i));
            if (!dataProviderLineAsList.equals(dataAsList)) continue;
            return Optional.of(i);
        }
        return Optional.empty();
    }

    private List<String> toStringsList(Object[] data) {
        return Arrays.stream(data).map(Objects::toString).collect(Collectors.toList());
    }

    private Optional<Integer> getIndexOfMatchingDataProviderData(Object[] actualTestParameters) {
        DataProviderData currentDataProviderData = this.currentDataProviderData.get();
        if (currentDataProviderData != null && Arrays.equals(currentDataProviderData.parameters, actualTestParameters)) {
            return Optional.ofNullable(currentDataProviderData.index);
        }
        return Optional.empty();
    }

    public void incrementInvocationIndex() {
        this.currentInvocationCount.get().incrementAndGet();
    }

    public int getCurrentInvocationIndex() {
        return this.currentInvocationCount.get().get();
    }

    public List<Integer> getDataProviderIndicesForRerun() {
        return this.dataProviderIndicesForRerun;
    }

    private static class DataProviderData {
        private final Object[] parameters;
        private final Integer index;

        public DataProviderData(Object[] parameters, Integer index) {
            this.parameters = parameters;
            this.index = index;
        }
    }
}

