/*
 * Decompiled with CFR 0.152.
 */
package com.zebrunner.agent.testng.core;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.testng.ITestClass;
import org.testng.ITestNGMethod;
import org.testng.internal.ParameterInfo;

public class FactoryInstanceHolder {
    private static final Map<String, List<Object>> CLASS_NAME_TO_INSTANCES = new ConcurrentHashMap<String, List<Object>>();

    public static void registerInstances(Collection<ITestClass> testClasses) {
        testClasses.forEach(testClass -> {
            String className = testClass.getName();
            List<Object> instances = FactoryInstanceHolder.getInstances(testClass);
            if (!instances.isEmpty()) {
                CLASS_NAME_TO_INSTANCES.putIfAbsent(className, instances);
            }
        });
    }

    private static List<Object> getInstances(ITestClass testClass) {
        return Arrays.stream(testClass.getInstances(true)).map(o -> o instanceof ParameterInfo ? ((ParameterInfo)o).getInstance() : o).collect(Collectors.toList());
    }

    public static int getInstanceIndex(ITestNGMethod method) {
        if (method.getInstance() != null) {
            String className = method.getTestClass().getName();
            List instances = CLASS_NAME_TO_INSTANCES.getOrDefault(className, Collections.emptyList());
            return instances.indexOf(method.getInstance());
        }
        return -1;
    }
}

