/*
 * Decompiled with CFR 0.152.
 */
package com.zebrunner.agent.core.registrar.descriptor;

import com.zebrunner.agent.core.registrar.domain.TestSessionDTO;
import java.time.Instant;
import java.util.Map;

public class SessionStartDescriptor {
    private final Instant initiatedAt = Instant.now();
    private final Map<String, Object> desiredCapabilities;
    private TestSessionDTO.Status status;
    private Instant startedAt;
    private String sessionId;
    private Map<String, Object> capabilities;
    private String failureReason;

    public static SessionStartDescriptor initiatedWith(Map<String, Object> desiredCapabilities) {
        return new SessionStartDescriptor(desiredCapabilities);
    }

    public void successfullyStartedWith(String sessionId, Map<String, Object> capabilities) {
        this.status = TestSessionDTO.Status.RUNNING;
        this.startedAt = Instant.now();
        this.sessionId = sessionId;
        this.capabilities = capabilities;
    }

    public void failedToStart(String failureReason) {
        this.status = TestSessionDTO.Status.FAILED;
        this.failureReason = failureReason;
    }

    public Instant getInitiatedAt() {
        return this.initiatedAt;
    }

    public Map<String, Object> getDesiredCapabilities() {
        return this.desiredCapabilities;
    }

    public TestSessionDTO.Status getStatus() {
        return this.status;
    }

    public Instant getStartedAt() {
        return this.startedAt;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public Map<String, Object> getCapabilities() {
        return this.capabilities;
    }

    public String getFailureReason() {
        return this.failureReason;
    }

    private SessionStartDescriptor(Map<String, Object> desiredCapabilities) {
        this.desiredCapabilities = desiredCapabilities;
    }
}

