/*
 * Decompiled with CFR 0.152.
 */
package com.zebrunner.agent.core.registrar;

import com.zebrunner.agent.core.config.ConfigurationHolder;
import com.zebrunner.agent.core.exception.ServerException;
import com.zebrunner.agent.core.logging.Log;
import com.zebrunner.agent.core.registrar.RetryUtils;
import com.zebrunner.agent.core.registrar.ZebrunnerApiClient;
import com.zebrunner.agent.core.registrar.domain.ArtifactReferenceDTO;
import com.zebrunner.agent.core.registrar.domain.AutenticationData;
import com.zebrunner.agent.core.registrar.domain.ExchangeRunContextResponse;
import com.zebrunner.agent.core.registrar.domain.KnownIssueConfirmation;
import com.zebrunner.agent.core.registrar.domain.LabelDTO;
import com.zebrunner.agent.core.registrar.domain.ObjectMapperImpl;
import com.zebrunner.agent.core.registrar.domain.TestCaseResult;
import com.zebrunner.agent.core.registrar.domain.TestDTO;
import com.zebrunner.agent.core.registrar.domain.TestRunDTO;
import com.zebrunner.agent.core.registrar.domain.TestRunPlatform;
import com.zebrunner.agent.core.registrar.domain.TestSessionDTO;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import kong.unirest.Config;
import kong.unirest.ContentType;
import kong.unirest.HttpRequestWithBody;
import kong.unirest.HttpResponse;
import kong.unirest.JsonPatchRequest;
import kong.unirest.ObjectMapper;
import kong.unirest.RequestBodyEntity;
import kong.unirest.Unirest;
import kong.unirest.UnirestInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class UnirestZebrunnerApiClient
implements ZebrunnerApiClient {
    private static final Logger log = LoggerFactory.getLogger(UnirestZebrunnerApiClient.class);
    private static UnirestZebrunnerApiClient INSTANCE;
    private String apiHost;
    private String authToken;
    private volatile UnirestInstance client;

    private UnirestZebrunnerApiClient() {
        if (ConfigurationHolder.isReportingEnabled()) {
            this.apiHost = ConfigurationHolder.getHost();
            this.client = this.initClient();
            this.authToken = this.authenticateClient();
            Config config = this.client.config();
            config.addDefaultHeader("Authorization", this.authToken);
        }
    }

    static synchronized UnirestZebrunnerApiClient getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new UnirestZebrunnerApiClient();
        }
        return INSTANCE;
    }

    private UnirestInstance initClient() {
        Config config = new Config();
        config.addDefaultHeader("Connection", "close");
        config.addDefaultHeader("Content-Type", "application/json");
        config.addDefaultHeader("Accept", "application/json");
        config.setObjectMapper((ObjectMapper)new ObjectMapperImpl());
        return new UnirestInstance(config);
    }

    private String authenticateClient() {
        String refreshToken = ConfigurationHolder.getToken();
        HttpResponse response = this.client.post(this.apiHost + "/api/iam/v1/auth/refresh").body(Collections.singletonMap("refreshToken", refreshToken)).asObject(AutenticationData.class).map(authData -> authData.getAuthTokenType() + " " + authData.getAuthToken());
        if (!response.isSuccess()) {
            this.client = null;
            this.throwServerException("Not able to obtain api token.", response);
        }
        return (String)response.getBody();
    }

    private String reportingAPI(String endpointPath) {
        return String.format("%s/api/reporting%s", this.apiHost, endpointPath);
    }

    private String formatError(String message, HttpResponse<?> response) {
        return String.format("%s\nResponse status code: %s.\nRaw response body: \n%s", message, response.getStatus(), response.mapError(String.class));
    }

    private void throwServerException(String message, HttpResponse<?> response) {
        throw new ServerException(this.formatError(message, response));
    }

    private <T> T sendRequest(Function<UnirestInstance, HttpResponse<T>> requestExecutor) {
        if (this.client != null) {
            return (T)RetryUtils.tryInvoke(() -> ((HttpResponse)requestExecutor.apply(this.client)).getBody(), this::isVolatileRecoverableException, 3);
        }
        return null;
    }

    private void sendVoidRequest(Consumer<UnirestInstance> requestExecutor) {
        if (this.client != null) {
            RetryUtils.tryInvoke(() -> requestExecutor.accept(this.client), this::isVolatileRecoverableException, 3);
        }
    }

    private boolean isVolatileRecoverableException(Throwable e) {
        do {
            String message;
            String string = message = (message = e.getMessage()) != null ? message.toLowerCase() : "";
            if (!message.contains("connection reset") && !message.contains("unable to find valid certification path")) continue;
            return true;
        } while ((e = e.getCause()) != null && e != e.getCause());
        return false;
    }

    @Override
    public TestRunDTO registerTestRunStart(TestRunDTO testRun) {
        return (TestRunDTO)this.sendRequest(client -> ((RequestBodyEntity)client.post(this.reportingAPI("/v1/test-runs")).body((Object)testRun).queryString("projectKey", (Object)ConfigurationHolder.getProjectKey())).asObject(TestRunDTO.class).ifFailure(response -> {
            this.client = null;
            this.throwServerException("Could not register start of the test run.", (HttpResponse<?>)response);
        }));
    }

    @Override
    public void patchTestRunBuild(Long testRunId, String build) {
        this.sendVoidRequest(client -> ((JsonPatchRequest)client.jsonPatch(this.reportingAPI("/v1/test-runs/{testRunId}")).routeParam("testRunId", testRunId.toString())).replace("/config/build", (Object)build).asString().ifFailure(response -> this.throwServerException("Could not patch build of the test run.", (HttpResponse<?>)response)));
    }

    @Override
    public void setTestRunPlatform(Long testRunId, String platformName, String platformVersion) {
        this.sendVoidRequest(client -> ((HttpRequestWithBody)client.put(this.reportingAPI("/v1/test-runs/{testRunId}/platform")).routeParam("testRunId", testRunId.toString())).body((Object)new TestRunPlatform(platformName, platformVersion)).asString().ifFailure(response -> this.throwServerException("Could not set platform of the test run.", (HttpResponse<?>)response)));
    }

    @Override
    public void registerTestRunFinish(TestRunDTO testRun) {
        this.sendVoidRequest(client -> ((RequestBodyEntity)client.put(this.reportingAPI("/v1/test-runs/{testRunId}")).body((Object)testRun).routeParam("testRunId", testRun.getId().toString())).asString().ifFailure(response -> this.throwServerException("Could not register finish of the test run.", (HttpResponse<?>)response)));
    }

    @Override
    public TestDTO registerTestStart(Long testRunId, TestDTO test, boolean headless) {
        return (TestDTO)this.sendRequest(client -> ((RequestBodyEntity)((RequestBodyEntity)client.post(this.reportingAPI("/v1/test-runs/{testRunId}/tests")).body((Object)test).routeParam("testRunId", testRunId.toString())).queryString("headless", (Object)headless)).asObject(TestDTO.class).ifFailure(response -> this.throwServerException("Could not register start of the test.", (HttpResponse<?>)response)));
    }

    @Override
    public TestDTO registerTestRerunStart(Long testRunId, Long testId, TestDTO test, boolean headless) {
        return (TestDTO)this.sendRequest(client -> ((RequestBodyEntity)((RequestBodyEntity)((RequestBodyEntity)client.post(this.reportingAPI("/v1/test-runs/{testRunId}/tests/{testId}")).body((Object)test).routeParam("testRunId", testRunId.toString())).routeParam("testId", testId.toString())).queryString("headless", (Object)headless)).asObject(TestDTO.class).ifFailure(response -> this.throwServerException("Could not register start of rerun of the test.", (HttpResponse<?>)response)));
    }

    @Override
    public TestDTO registerHeadlessTestUpdate(Long testRunId, TestDTO test) {
        return (TestDTO)this.sendRequest(client -> ((HttpRequestWithBody)((HttpRequestWithBody)((HttpRequestWithBody)client.put(this.reportingAPI("/v1/test-runs/{testRunId}/tests/{testId}")).routeParam("testRunId", testRunId.toString())).routeParam("testId", test.getId().toString())).queryString("headless", (Object)true)).body((Object)test).asObject(TestDTO.class).ifFailure(response -> this.throwServerException("Could not register start of the test.", (HttpResponse<?>)response)));
    }

    @Override
    public void revertTestRegistration(Long testRunId, Long testId) {
        this.sendVoidRequest(client -> ((HttpRequestWithBody)((HttpRequestWithBody)client.delete(this.reportingAPI("/v1/test-runs/{testRunId}/tests/{testId}")).routeParam("testRunId", testRunId.toString())).routeParam("testId", testId.toString())).asString().ifFailure(response -> this.throwServerException("Could not revert test registration.", (HttpResponse<?>)response)));
    }

    @Override
    public void registerTestFinish(Long testRunId, TestDTO test) {
        this.sendVoidRequest(client -> ((HttpRequestWithBody)((HttpRequestWithBody)((HttpRequestWithBody)client.put(this.reportingAPI("/v1/test-runs/{testRunId}/tests/{testId}")).routeParam("testRunId", testRunId.toString())).routeParam("testId", test.getId().toString())).queryString("headless", (Object)false)).body((Object)test).asString().ifFailure(response -> this.throwServerException("Could not register finish of the test.", (HttpResponse<?>)response)));
    }

    @Override
    public void sendLogs(Collection<Log> logs, Long testRunId) {
        this.sendVoidRequest(client -> ((HttpRequestWithBody)client.post(this.reportingAPI("/v1/test-runs/{testRunId}/logs")).routeParam("testRunId", testRunId.toString())).body((Object)logs).asString().ifFailure(response -> log.error(this.formatError("Could not send a batch of test logs.", (HttpResponse<?>)response))));
    }

    @Override
    public void upsertTestCaseResults(Long testRunId, Long testId, Collection<TestCaseResult> testCaseResults) {
        this.sendVoidRequest(client -> ((HttpRequestWithBody)((HttpRequestWithBody)client.post(this.reportingAPI("/v1/test-runs/{testRunId}/tests/{testId}/test-cases:upsert")).routeParam("testRunId", testRunId.toString())).routeParam("testId", testId.toString())).body(Collections.singletonMap("testCases", testCaseResults)).asString().ifFailure(response -> {
            if (response.getStatus() == 404) {
                log.warn("This functionality is not available for your Zebrunner distribution");
            } else {
                log.error(this.formatError("Could not send test case results.", (HttpResponse<?>)response));
            }
        }));
    }

    @Override
    public void uploadScreenshot(byte[] screenshot, Long testRunId, Long testId, Long capturedAt) {
        this.sendVoidRequest(client -> ((HttpRequestWithBody)((HttpRequestWithBody)((HttpRequestWithBody)((HttpRequestWithBody)client.post(this.reportingAPI("/v1/test-runs/{testRunId}/tests/{testId}/screenshots")).headerReplace("Content-Type", ContentType.IMAGE_PNG.getMimeType())).routeParam("testRunId", testRunId.toString())).routeParam("testId", testId.toString())).header("x-zbr-screenshot-captured-at", capturedAt.toString())).body(screenshot).asString().ifFailure(response -> log.error(this.formatError("Could not upload a screenshot.", (HttpResponse<?>)response))));
    }

    @Override
    public void uploadTestRunArtifact(InputStream artifact, String name, Long testRunId) {
        this.sendVoidRequest(client -> ((HttpRequestWithBody)((HttpRequestWithBody)Unirest.post((String)this.reportingAPI("/v1/test-runs/{testRunId}/artifacts")).header("Authorization", this.authToken)).routeParam("testRunId", testRunId.toString())).field("file", artifact, name).asString().ifFailure(response -> log.error(this.formatError("Could not attach test run artifact with name " + name, (HttpResponse<?>)response))));
    }

    @Override
    public void uploadTestArtifact(InputStream artifact, String name, Long testRunId, Long testId) {
        this.sendVoidRequest(client -> ((HttpRequestWithBody)((HttpRequestWithBody)((HttpRequestWithBody)Unirest.post((String)this.reportingAPI("/v1/test-runs/{testRunId}/tests/{testId}/artifacts")).header("Authorization", this.authToken)).routeParam("testRunId", testRunId.toString())).routeParam("testId", testId.toString())).field("file", artifact, name).asString().ifFailure(response -> log.error(this.formatError("Could not attach test artifact with name " + name, (HttpResponse<?>)response))));
    }

    @Override
    public void attachArtifactReferenceToTestRun(Long testRunId, ArtifactReferenceDTO artifactReference) {
        Map<String, List<ArtifactReferenceDTO>> requestBody = Collections.singletonMap("items", Collections.singletonList(artifactReference));
        this.sendVoidRequest(client -> ((HttpRequestWithBody)client.put(this.reportingAPI("/v1/test-runs/{testRunId}/artifact-references")).routeParam("testRunId", testRunId.toString())).body((Object)requestBody).asString().ifFailure(response -> log.error(this.formatError("Could not attach the following test run artifact reference: " + artifactReference, (HttpResponse<?>)response))));
    }

    @Override
    public void attachArtifactReferenceToTest(Long testRunId, Long testId, ArtifactReferenceDTO artifactReference) {
        this.sendVoidRequest(client -> ((HttpRequestWithBody)((HttpRequestWithBody)client.put(this.reportingAPI("/v1/test-runs/{testRunId}/tests/{testId}/artifact-references")).routeParam("testRunId", testRunId.toString())).routeParam("testId", testId.toString())).body(Collections.singletonMap("items", Collections.singletonList(artifactReference))).asString().ifFailure(response -> log.error(this.formatError("Could not attach the following test artifact reference: " + artifactReference, (HttpResponse<?>)response))));
    }

    @Override
    public void attachLabelsToTestRun(Long testRunId, Collection<LabelDTO> labels) {
        this.sendVoidRequest(client -> ((HttpRequestWithBody)client.put(this.reportingAPI("/v1/test-runs/{testRunId}/labels")).routeParam("testRunId", testRunId.toString())).body(Collections.singletonMap("items", labels)).asString().ifFailure(response -> log.error(this.formatError("Could not attach the following labels to test run: " + labels, (HttpResponse<?>)response))));
    }

    @Override
    public void attachLabelsToTest(Long testRunId, Long testId, Collection<LabelDTO> labels) {
        this.sendVoidRequest(client -> ((HttpRequestWithBody)((HttpRequestWithBody)client.put(this.reportingAPI("/v1/test-runs/{testRunId}/tests/{testId}/labels")).routeParam("testRunId", testRunId.toString())).routeParam("testId", testId.toString())).body(Collections.singletonMap("items", labels)).asString().ifFailure(response -> log.error(this.formatError("Could not attach the following labels to test: " + labels, (HttpResponse<?>)response))));
    }

    @Override
    public ExchangeRunContextResponse exchangeRerunCondition(String rerunCondition) {
        return (ExchangeRunContextResponse)this.sendRequest(client -> client.post(this.reportingAPI("/v1/run-context-exchanges")).body(rerunCondition).asObject(ExchangeRunContextResponse.class).ifFailure(response -> this.throwServerException("Could not get tests by ci run id.", (HttpResponse<?>)response)));
    }

    @Override
    public TestSessionDTO startSession(Long testRunId, TestSessionDTO testSession) {
        return (TestSessionDTO)this.sendRequest(client -> ((HttpRequestWithBody)client.post(this.reportingAPI("/v1/test-runs/{testRunId}/test-sessions")).routeParam("testRunId", testRunId.toString())).body((Object)testSession).asObject(TestSessionDTO.class).ifFailure(response -> this.throwServerException("Could not register start of the test session.", (HttpResponse<?>)response)));
    }

    @Override
    public void updateSession(Long testRunId, TestSessionDTO testSession) {
        this.sendVoidRequest(client -> ((HttpRequestWithBody)((HttpRequestWithBody)client.put(this.reportingAPI("/v1/test-runs/{testRunId}/test-sessions/{testSessionId}")).routeParam("testRunId", testRunId.toString())).routeParam("testSessionId", testSession.getId().toString())).body((Object)testSession).asString().ifFailure(response -> this.throwServerException("Could not update test session.", (HttpResponse<?>)response)));
    }

    @Override
    public boolean isKnownIssueAttachedToTest(Long testRunId, Long testId, String failureStacktrace) {
        KnownIssueConfirmation confirmation = (KnownIssueConfirmation)this.sendRequest(client -> ((HttpRequestWithBody)((HttpRequestWithBody)client.post(this.reportingAPI("/v1/test-runs/{testRunId}/tests/{testId}/known-issue-confirmations")).routeParam("testRunId", testRunId.toString())).routeParam("testId", testId.toString())).body(Collections.singletonMap("failureReason", failureStacktrace)).asObject(KnownIssueConfirmation.class).ifFailure(response -> this.throwServerException("Could not retrieve status of attached known issues.", (HttpResponse<?>)response)));
        return confirmation != null && confirmation.isKnownIssue();
    }
}

