/*
 * Decompiled with CFR 0.152.
 */
package com.zebrunner.agent.core.registrar;

import com.zebrunner.agent.core.registrar.Label;
import com.zebrunner.agent.core.registrar.TestCasesRegistry;
import com.zebrunner.agent.core.registrar.domain.TcmType;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TestCase {
    private static final Logger log = LoggerFactory.getLogger(TestCase.class);
    public static final String SYNC_ENABLED = "com.zebrunner.app/tcm.zebrunner.sync.enabled";
    public static final String SYNC_REAL_TIME = "com.zebrunner.app/tcm.zebrunner.sync.real-time";
    public static final String TEST_RUN_ID = "com.zebrunner.app/tcm.zebrunner.test-run-id";
    private static final TestCasesRegistry TEST_CASES_REGISTRY = TestCasesRegistry.getInstance();
    private static volatile boolean isRealTimeSyncEnabled = false;

    public static void disableSync() {
        TestCase.attachLabelToTestRun(SYNC_ENABLED, "false");
    }

    public static synchronized void enableRealTimeSync() {
        if (!isRealTimeSyncEnabled) {
            TestCase.attachLabelToTestRun(SYNC_REAL_TIME, "true");
            isRealTimeSyncEnabled = true;
        } else {
            log.warn("Realtime sync for Zebrunner TCM already enabled.");
        }
    }

    public static void setTestRunId(String id) {
        TestCase.attachLabelToTestRun(TEST_RUN_ID, id);
    }

    private static void attachLabelToTestRun(String name, String ... values) {
        if (isRealTimeSyncEnabled) {
            log.warn("Realtime sync for Zebrunner TCM has been enabled, so you cannot overwrite TCM configuration");
        } else {
            Label.attachToTestRun(name, values);
        }
    }

    public static void setTestCaseKey(String testCaseKey) {
        TEST_CASES_REGISTRY.addTestCasesToCurrentTest(TcmType.ZEBRUNNER, Collections.singleton(testCaseKey));
    }

    public static void setTestCaseStatus(String testCaseKey, String resultStatus) {
        TEST_CASES_REGISTRY.setCurrentTestTestCaseStatus(TcmType.ZEBRUNNER, testCaseKey, resultStatus);
    }

    private TestCase() {
    }

    public static final class SystemTestCaseStatus {
        public static final String PASSED = "Passed";
        public static final String FAILED = "Failed";
        public static final String SKIPPED = "Skipped";
        public static final String RETEST = "Retest";
        public static final String BLOCKED = "Blocked";
        public static final String INVALID = "Invalid";

        private SystemTestCaseStatus() {
        }
    }
}

