/*
 * Decompiled with CFR 0.152.
 */
package com.zebrunner.agent.core.registrar;

import com.zebrunner.agent.core.registrar.descriptor.TestDescriptor;
import com.zebrunner.agent.core.registrar.descriptor.TestFinishDescriptor;
import com.zebrunner.agent.core.registrar.descriptor.TestRunDescriptor;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

class RunContext {
    private static TestRunDescriptor testRun;
    private static final Map<String, TestDescriptor> TESTS;
    private static final ThreadLocal<TestDescriptor> CURRENT_THREAD_LOCAL_TEST;
    private static final ThreadLocal<TestDescriptor> CURRENT_THREAD_LOCAL_AFTER_METHOD;
    private static final ThreadLocal<TestDescriptor> PREVIOUS_COMPLETED_THREAD_LOCAL_TEST;

    RunContext() {
    }

    static void setRun(TestRunDescriptor testRunDescriptor) {
        testRun = testRunDescriptor;
    }

    static TestRunDescriptor getRun() {
        return testRun;
    }

    static boolean hasTests() {
        return !TESTS.isEmpty();
    }

    static Long getZebrunnerRunId() {
        return testRun != null ? testRun.getZebrunnerId() : null;
    }

    static TestDescriptor getTest(String id) {
        return TESTS.get(id);
    }

    static void addCurrentTest(String id, TestDescriptor testDescriptor) {
        TESTS.put(id, testDescriptor);
        CURRENT_THREAD_LOCAL_TEST.set(testDescriptor);
    }

    static Optional<TestDescriptor> getCurrentTest() {
        return Optional.ofNullable(CURRENT_THREAD_LOCAL_TEST.get());
    }

    static Optional<TestDescriptor> removeCurrentTest() {
        Optional<TestDescriptor> maybeCurrentTest = RunContext.getCurrentTest();
        maybeCurrentTest.ifPresent(currentTest -> {
            TESTS.values().removeIf(test -> test == currentTest);
            CURRENT_THREAD_LOCAL_TEST.remove();
        });
        return maybeCurrentTest;
    }

    static void completeTest(String id, TestFinishDescriptor tf) {
        TestDescriptor testToComplete = RunContext.getTest(id);
        if (testToComplete != null) {
            testToComplete.complete(tf);
            TestDescriptor threadLocalTest = CURRENT_THREAD_LOCAL_TEST.get();
            if (threadLocalTest == testToComplete) {
                CURRENT_THREAD_LOCAL_TEST.remove();
                PREVIOUS_COMPLETED_THREAD_LOCAL_TEST.set(testToComplete);
            }
        }
    }

    static void startAfterMethod() {
        TestDescriptor previousTest;
        if (CURRENT_THREAD_LOCAL_TEST.get() == null && (previousTest = PREVIOUS_COMPLETED_THREAD_LOCAL_TEST.get()) != null) {
            PREVIOUS_COMPLETED_THREAD_LOCAL_TEST.remove();
            CURRENT_THREAD_LOCAL_TEST.set(previousTest);
            CURRENT_THREAD_LOCAL_AFTER_METHOD.set(previousTest);
        }
    }

    static void finishAfterMethod() {
        TestDescriptor testToComplete = CURRENT_THREAD_LOCAL_AFTER_METHOD.get();
        if (testToComplete != null) {
            PREVIOUS_COMPLETED_THREAD_LOCAL_TEST.set(testToComplete);
            CURRENT_THREAD_LOCAL_TEST.remove();
            CURRENT_THREAD_LOCAL_AFTER_METHOD.remove();
        }
    }

    static {
        TESTS = new ConcurrentHashMap<String, TestDescriptor>();
        CURRENT_THREAD_LOCAL_TEST = new InheritableThreadLocal<TestDescriptor>();
        CURRENT_THREAD_LOCAL_AFTER_METHOD = new InheritableThreadLocal<TestDescriptor>();
        PREVIOUS_COMPLETED_THREAD_LOCAL_TEST = new ThreadLocal();
    }
}

