/*
 * Decompiled with CFR 0.152.
 */
package com.zebrunner.agent.core.config.provider;

import com.zebrunner.agent.core.config.ConfigurationProvider;
import com.zebrunner.agent.core.config.ConfigurationUtils;
import com.zebrunner.agent.core.config.ReportingConfiguration;
import com.zebrunner.agent.core.config.annotation.Configuration;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Objects;

public abstract class AnnotationDrivenConfigurationProvider<T extends Annotation>
implements ConfigurationProvider {
    private final Class<T> annotationClass;

    protected AnnotationDrivenConfigurationProvider(Class<T> annotationClass) {
        this.annotationClass = annotationClass;
    }

    @Override
    public ReportingConfiguration getConfiguration() {
        ReportingConfiguration configuration = new ReportingConfiguration();
        this.beforePropertiesSet();
        this.setProperties(configuration);
        this.afterPropertiesSet();
        return configuration;
    }

    private void setProperties(Object configuration) {
        for (Field field : configuration.getClass().getDeclaredFields()) {
            if (field.isAnnotationPresent(Configuration.class)) {
                Object nestedConfiguration = this.createNewInstanceOf(field);
                this.setProperties(nestedConfiguration);
                this.setFieldValue(configuration, field, nestedConfiguration);
                continue;
            }
            T annotation = field.getAnnotation(this.annotationClass);
            if (annotation == null) continue;
            this.getConfigurationFieldKeys(annotation).stream().map(this::getConfigurationFieldValue).filter(Objects::nonNull).findFirst().map(fieldValue -> this.parse(field, (String)fieldValue)).ifPresent(fieldValue -> this.setFieldValue(configuration, field, fieldValue));
        }
    }

    private Object createNewInstanceOf(Field field) {
        try {
            Constructor<?> noArgsConstructor = field.getType().getDeclaredConstructor(new Class[0]);
            noArgsConstructor.setAccessible(true);
            Object newInstance = noArgsConstructor.newInstance(new Object[0]);
            noArgsConstructor.setAccessible(false);
            return newInstance;
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(String.format("No-args constructor doesn't exist for type: %s", field.getType().getName()));
        }
    }

    private Object parse(Field field, String value) {
        if (value == null) {
            return null;
        }
        Object parsedValue = value;
        if (field.getType() == Boolean.class) {
            parsedValue = ConfigurationUtils.parseBoolean(value);
        } else if (field.getType() == Long.class) {
            parsedValue = ConfigurationUtils.parseLong(value);
        }
        return parsedValue;
    }

    private void setFieldValue(Object fieldHolder, Field field, Object value) {
        field.setAccessible(true);
        field.set(fieldHolder, value);
        field.setAccessible(false);
    }

    protected void beforePropertiesSet() {
    }

    protected void afterPropertiesSet() {
    }

    protected abstract List<String> getConfigurationFieldKeys(T var1);

    protected abstract String getConfigurationFieldValue(String var1);
}

