/*
 * Decompiled with CFR 0.152.
 */
package com.yugabyte.ysql;

import com.yugabyte.core.PGStream;
import com.yugabyte.jdbc.PgConnection;
import com.yugabyte.util.GT;
import com.yugabyte.util.HostSpec;
import com.yugabyte.util.PSQLException;
import com.yugabyte.util.PSQLState;
import com.yugabyte.util.internal.Nullness;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;

public class YBManagedHostnameVerifier
implements HostnameVerifier {
    private static final Logger LOGGER = Logger.getLogger("com.yugabyte." + YBManagedHostnameVerifier.class.getName());
    protected static final String GET_SERVERS_QUERY = "select * from yb_servers()";
    protected Boolean useHostColumn = null;
    private static final int TYPE_DNS_NAME = 2;
    private static final int TYPE_IP_ADDRESS = 7;
    private final Properties originalProperties;
    protected ArrayList<String> currentPublicIps = new ArrayList();
    protected Map<String, String> hostPortMap = new HashMap<String, String>();
    protected Map<String, String> hostPortMapPublic = new HashMap<String, String>();
    private final PGStream stream;
    private static Connection controlConnection = null;

    public YBManagedHostnameVerifier(Properties props, PGStream stream) {
        this.originalProperties = props;
        this.stream = stream;
    }

    @Override
    public boolean verify(String hostname, SSLSession session) {
        Collection<List<?>> subjectAltNames;
        X509Certificate[] peerCerts;
        try {
            peerCerts = (X509Certificate[])session.getPeerCertificates();
        }
        catch (SSLPeerUnverifiedException e) {
            LOGGER.log(Level.SEVERE, GT.tr("Unable to parse X509Certificate for hostname {0}", hostname), e);
            return false;
        }
        if (peerCerts == null || peerCerts.length == 0) {
            LOGGER.log(Level.SEVERE, GT.tr("No certificates found for hostname {0}", hostname));
            return false;
        }
        X509Certificate serverCert = peerCerts[0];
        try {
            subjectAltNames = serverCert.getSubjectAlternativeNames();
            if (subjectAltNames == null) {
                subjectAltNames = Collections.emptyList();
            }
        }
        catch (CertificateParsingException e) {
            LOGGER.log(Level.SEVERE, GT.tr("Unable to parse certificates for hostname {0}", hostname), e);
            return false;
        }
        boolean anyDnsSan = false;
        String san = null;
        for (List<?> sanItem : subjectAltNames) {
            Integer sanType;
            if (sanItem.size() != 2 || (sanType = (Integer)sanItem.get(0)) == null || sanType != 7 && sanType != 2) continue;
            san = (String)sanItem.get(1);
            if (sanType == 7 && san != null && san.startsWith("*")) continue;
            anyDnsSan |= sanType == 2;
        }
        this.originalProperties.setProperty("PGHOST", san);
        HostSpec[] hspec = YBManagedHostnameVerifier.hostSpecs(this.originalProperties);
        try {
            if (controlConnection == null) {
                controlConnection = new PgConnection(hspec, this.originalProperties.getProperty("user", ""), this.originalProperties.getProperty("PGDBNAME", ""), this.originalProperties, null);
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        ArrayList<Object> hostlist = new ArrayList();
        try {
            hostlist = this.getCurrentServers(controlConnection);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        return hostlist.contains(hostname);
    }

    private ArrayList<String> getCurrentServers(Connection conn) throws SQLException {
        InetAddress hostConnectedInetAddr;
        Statement st = conn.createStatement();
        ResultSet rs = st.executeQuery(GET_SERVERS_QUERY);
        ArrayList<String> currentPrivateIps = new ArrayList<String>();
        String hostConnectedTo = ((PgConnection)conn).getQueryExecutor().getHostSpec().getHost();
        boolean isIpv6Addresses = hostConnectedTo.contains(":");
        if (isIpv6Addresses) {
            hostConnectedTo = hostConnectedTo.replace("[", "").replace("]", "");
        }
        try {
            hostConnectedInetAddr = InetAddress.getByName(hostConnectedTo);
        }
        catch (UnknownHostException e) {
            throw new PSQLException(GT.tr("Unexpected UnknownHostException for ${0} ", hostConnectedTo), PSQLState.UNKNOWN_STATE, (Throwable)e);
        }
        this.currentPublicIps.clear();
        while (rs.next()) {
            InetAddress publicHostInetAddr;
            InetAddress hostInetAddr;
            String host = rs.getString("host");
            String publicHost = rs.getString("public_ip");
            String port = rs.getString("port");
            String cloud = rs.getString("cloud");
            String region = rs.getString("region");
            String zone = rs.getString("zone");
            this.hostPortMap.put(host, port);
            this.hostPortMapPublic.put(publicHost, port);
            currentPrivateIps.add(host);
            if (!publicHost.trim().isEmpty()) {
                this.currentPublicIps.add(publicHost);
            }
            try {
                hostInetAddr = InetAddress.getByName(host);
            }
            catch (UnknownHostException e) {
                hostInetAddr = null;
            }
            try {
                publicHostInetAddr = !publicHost.isEmpty() ? InetAddress.getByName(publicHost) : null;
            }
            catch (UnknownHostException e) {
                publicHostInetAddr = null;
            }
            if (this.useHostColumn != null) continue;
            if (hostConnectedInetAddr.equals(hostInetAddr)) {
                this.useHostColumn = Boolean.TRUE;
                continue;
            }
            if (!hostConnectedInetAddr.equals(publicHostInetAddr)) continue;
            this.useHostColumn = Boolean.FALSE;
        }
        if (this.useHostColumn == null) {
            if (this.currentPublicIps.isEmpty()) {
                this.useHostColumn = Boolean.TRUE;
            }
            return currentPrivateIps;
        }
        ArrayList<String> currentHosts = this.useHostColumn != false ? currentPrivateIps : this.currentPublicIps;
        return currentHosts;
    }

    private static HostSpec[] hostSpecs(Properties props) {
        String[] hosts = Nullness.castNonNull(props.getProperty("PGHOST")).split(",");
        String[] ports = Nullness.castNonNull(props.getProperty("PGPORT")).split(",");
        String localSocketAddress = props.getProperty("localSocketAddress");
        HostSpec[] hostSpecs = new HostSpec[hosts.length];
        for (int i = 0; i < hostSpecs.length; ++i) {
            hostSpecs[i] = new HostSpec(hosts[i], Integer.parseInt(ports[i]), localSocketAddress);
        }
        return hostSpecs;
    }
}

