/*
 * Decompiled with CFR 0.152.
 */
package com.yugabyte.ysql;

import com.yugabyte.ysql.LoadBalanceService;
import com.yugabyte.ysql.LoadBalancer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import java.util.logging.Logger;

public class TopologyAwareLoadBalancer
implements LoadBalancer {
    protected static final Logger LOGGER = Logger.getLogger("com.yugabyte." + TopologyAwareLoadBalancer.class.getName());
    private final String placements;
    private long lastRequestTime;
    private final Map<Integer, Set<LoadBalanceService.CloudPlacement>> allowedPlacements = new HashMap<Integer, Set<LoadBalanceService.CloudPlacement>>();
    private final int PRIMARY_PLACEMENTS_INDEX = 1;
    private final int REST_OF_CLUSTER_INDEX = -1;
    private int currentPlacementIndex = 1;
    List<String> attempted = new ArrayList<String>();
    private int refreshIntervalSeconds;
    private boolean explicitFallbackOnly = false;

    public TopologyAwareLoadBalancer(String placementValues, boolean onlyExplicitFallback) {
        this.placements = placementValues;
        this.explicitFallbackOnly = onlyExplicitFallback;
        this.refreshIntervalSeconds = Integer.getInteger("yb-servers-refresh-interval", 300);
        this.parseGeoLocations();
    }

    protected String loadBalancingNodes() {
        return this.placements;
    }

    private void populatePlacementSet(String placement, Set<LoadBalanceService.CloudPlacement> allowedPlacements) {
        String[] placementParts = placement.split("\\.");
        if (placementParts.length != 3 || placementParts[0].equals("*") || placementParts[1].equals("*")) {
            LOGGER.warning("Malformed topology-keys property value: " + placement);
            throw new IllegalArgumentException("Malformed topology-keys property value: " + placement);
        }
        LoadBalanceService.CloudPlacement cp = new LoadBalanceService.CloudPlacement(placementParts[0], placementParts[1], placementParts[2]);
        LOGGER.fine("Adding placement " + cp + " to allowed list");
        allowedPlacements.add(cp);
    }

    private void parseGeoLocations() {
        String[] values;
        for (String value : values = this.placements.split(",")) {
            String[] v = value.split(":");
            if (v.length > 2 || value.endsWith(":")) {
                throw new IllegalArgumentException("Invalid value part for property topology-keys: " + value);
            }
            if (v.length == 1) {
                Set primary = this.allowedPlacements.computeIfAbsent(1, k -> new HashSet());
                this.populatePlacementSet(v[0], primary);
                continue;
            }
            int pref = Integer.valueOf(v[1]);
            if (pref > 0 && pref <= 10) {
                Set cpSet = this.allowedPlacements.computeIfAbsent(pref, k -> new HashSet());
                this.populatePlacementSet(v[0], cpSet);
                continue;
            }
            throw new IllegalArgumentException("Invalid preference value for property topology-keys: " + value);
        }
    }

    @Override
    public int getRefreshListSeconds() {
        return Integer.getInteger("yb-servers-refresh-interval", this.refreshIntervalSeconds);
    }

    public boolean isExplicitFallbackOnly() {
        return this.explicitFallbackOnly;
    }

    @Override
    public boolean isHostEligible(Map.Entry<String, LoadBalanceService.NodeInfo> e) {
        Set<LoadBalanceService.CloudPlacement> set = this.allowedPlacements.get(this.currentPlacementIndex);
        boolean found = this.currentPlacementIndex == -1 && !this.explicitFallbackOnly || set != null && e.getValue().getPlacement().isContainedIn(set);
        boolean isAttempted = this.attempted.contains(e.getKey());
        boolean isDown = e.getValue().isDown();
        LOGGER.fine(e.getKey() + " has required placement? " + found + ", isDown? " + isDown + ", attempted? " + isAttempted);
        return found && !isAttempted && !isDown;
    }

    @Override
    public synchronized String getLeastLoadedServer(boolean newRequest, List<String> failedHosts, ArrayList<String> timedOutHosts) {
        LOGGER.fine("newRequest: " + newRequest + ", failedHosts: " + failedHosts);
        if (newRequest && LoadBalanceService.getLastRefreshTime() - this.lastRequestTime >= 0L) {
            this.currentPlacementIndex = 1;
        } else {
            LOGGER.fine("Placements: [" + this.placements + "]. Attempting to connect to servers in fallback level-" + (this.currentPlacementIndex - 1) + " ...");
        }
        String chosenHost = null;
        while (chosenHost == null && this.currentPlacementIndex <= 10) {
            this.attempted = failedHosts;
            if (timedOutHosts != null) {
                this.attempted.addAll(timedOutHosts);
            }
            ArrayList<String> hosts = LoadBalanceService.getAllEligibleHosts(this);
            int min = Integer.MAX_VALUE;
            ArrayList<String> minConnectionsHostList = new ArrayList<String>();
            for (String h : hosts) {
                if (failedHosts.contains(h)) {
                    LOGGER.fine("Skipping failed host " + h);
                    continue;
                }
                int currLoad = LoadBalanceService.getLoad(h);
                LOGGER.fine("Number of connections to " + h + ": " + currLoad);
                if (currLoad < min) {
                    min = currLoad;
                    minConnectionsHostList.clear();
                    minConnectionsHostList.add(h);
                    continue;
                }
                if (currLoad != min) continue;
                minConnectionsHostList.add(h);
            }
            if (minConnectionsHostList.size() > 0) {
                int idx = ThreadLocalRandom.current().nextInt(0, minConnectionsHostList.size());
                chosenHost = (String)minConnectionsHostList.get(idx);
            }
            if (chosenHost != null) {
                LoadBalanceService.incrementConnectionCount(chosenHost);
                continue;
            }
            LOGGER.fine("chosenHost is null for placement level " + this.currentPlacementIndex + ", allowedPlacements: " + this.allowedPlacements);
            ++this.currentPlacementIndex;
            while (this.allowedPlacements.get(this.currentPlacementIndex) == null && this.currentPlacementIndex > 0) {
                ++this.currentPlacementIndex;
                if (this.currentPlacementIndex > 10) {
                    this.currentPlacementIndex = -1;
                    continue;
                }
                if (this.currentPlacementIndex != 0) continue;
            }
            if (this.currentPlacementIndex == 0) break;
            LOGGER.fine("Next, attempting to connect to hosts from placement level " + this.currentPlacementIndex);
        }
        this.lastRequestTime = System.currentTimeMillis();
        LOGGER.fine("Host chosen for new connection: " + chosenHost);
        return chosenHost;
    }
}

