/*
 * Decompiled with CFR 0.152.
 */
package com.yugabyte.ysql;

import com.yugabyte.ysql.LoadBalanceService;
import com.yugabyte.ysql.LoadBalancer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import java.util.logging.Logger;

public class ClusterAwareLoadBalancer
implements LoadBalancer {
    protected static final Logger LOGGER = Logger.getLogger("com.yugabyte." + ClusterAwareLoadBalancer.class.getName());
    private static volatile ClusterAwareLoadBalancer instance;
    List<String> attempted = new ArrayList<String>();
    protected int refreshListSeconds = 300;

    @Override
    public int getRefreshListSeconds() {
        return this.refreshListSeconds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ClusterAwareLoadBalancer getInstance(int refreshListSeconds) {
        if (instance != null) return instance;
        Class<ClusterAwareLoadBalancer> clazz = ClusterAwareLoadBalancer.class;
        synchronized (ClusterAwareLoadBalancer.class) {
            if (instance != null) return instance;
            instance = new ClusterAwareLoadBalancer();
            ClusterAwareLoadBalancer.instance.refreshListSeconds = refreshListSeconds >= 0 && refreshListSeconds <= 600 ? refreshListSeconds : 300;
            LOGGER.fine("Created a new cluster-aware LB instance with refresh interval " + ClusterAwareLoadBalancer.instance.refreshListSeconds + " seconds");
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    @Override
    public boolean isHostEligible(Map.Entry<String, LoadBalanceService.NodeInfo> e) {
        return !this.attempted.contains(e.getKey()) && !e.getValue().isDown();
    }

    @Override
    public synchronized String getLeastLoadedServer(boolean newRequest, List<String> failedHosts, ArrayList<String> timedOutHosts) {
        LOGGER.fine("failedHosts: " + failedHosts + ", timedOutHosts: " + timedOutHosts);
        this.attempted = failedHosts;
        if (timedOutHosts != null) {
            this.attempted.addAll(timedOutHosts);
        }
        ArrayList<String> hosts = LoadBalanceService.getAllEligibleHosts(this);
        int min = Integer.MAX_VALUE;
        ArrayList<String> minConnectionsHostList = new ArrayList<String>();
        for (String h : hosts) {
            boolean wasTimedOutHost;
            boolean bl = wasTimedOutHost = timedOutHosts != null && timedOutHosts.contains(h);
            if (failedHosts.contains(h) || wasTimedOutHost) {
                LOGGER.fine("Skipping failed host " + h + "(was timed out host=" + wasTimedOutHost + ")");
                continue;
            }
            int currLoad = LoadBalanceService.getLoad(h);
            LOGGER.fine("Number of connections to " + h + ": " + currLoad);
            if (currLoad < min) {
                min = currLoad;
                minConnectionsHostList.clear();
                minConnectionsHostList.add(h);
                continue;
            }
            if (currLoad != min) continue;
            minConnectionsHostList.add(h);
        }
        String chosenHost = null;
        if (minConnectionsHostList.size() > 0) {
            int idx = ThreadLocalRandom.current().nextInt(0, minConnectionsHostList.size());
            chosenHost = (String)minConnectionsHostList.get(idx);
        }
        if (chosenHost != null) {
            LoadBalanceService.incrementConnectionCount(chosenHost);
        }
        LOGGER.fine("Host chosen for new connection: " + chosenHost);
        return chosenHost;
    }
}

