/*
 * Decompiled with CFR 0.152.
 */
package com.yugabyte.core;

import com.yugabyte.PGProperty;
import com.yugabyte.ssl.LibPQFactory;
import com.yugabyte.util.GT;
import com.yugabyte.util.ObjectFactory;
import com.yugabyte.util.PSQLException;
import com.yugabyte.util.PSQLState;
import java.util.Properties;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocketFactory;

public class SocketFactoryFactory {
    public static SocketFactory getSocketFactory(Properties info) throws PSQLException {
        String socketFactoryClassName = PGProperty.SOCKET_FACTORY.get(info);
        if (socketFactoryClassName == null) {
            return SocketFactory.getDefault();
        }
        try {
            return (SocketFactory)ObjectFactory.instantiate(socketFactoryClassName, info, true, PGProperty.SOCKET_FACTORY_ARG.get(info));
        }
        catch (Exception e) {
            throw new PSQLException(GT.tr("The SocketFactory class provided {0} could not be instantiated.", socketFactoryClassName), PSQLState.CONNECTION_FAILURE, (Throwable)e);
        }
    }

    public static SSLSocketFactory getSslSocketFactory(Properties info) throws PSQLException {
        String classname = PGProperty.SSL_FACTORY.get(info);
        if (classname == null || "com.yugabyte.ssl.jdbc4.LibPQFactory".equals(classname) || "com.yugabyte.ssl.LibPQFactory".equals(classname)) {
            return new LibPQFactory(info);
        }
        try {
            return (SSLSocketFactory)ObjectFactory.instantiate(classname, info, true, PGProperty.SSL_FACTORY_ARG.get(info));
        }
        catch (Exception e) {
            throw new PSQLException(GT.tr("The SSLSocketFactory class provided {0} could not be instantiated.", classname), PSQLState.CONNECTION_FAILURE, (Throwable)e);
        }
    }
}

