/*
 * Decompiled with CFR 0.152.
 */
package com.x5.template;

import com.x5.template.BlockTag;
import com.x5.template.Chunk;
import com.x5.template.IfTag;
import com.x5.template.LocaleTag;
import com.x5.template.LoopTag;
import com.x5.template.MacroTag;
import com.x5.template.Snippet;
import com.x5.template.SnippetPart;
import com.x5.template.SnippetTag;
import java.io.IOException;
import java.io.Writer;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SnippetBlockTag
extends SnippetTag {
    private SnippetTag tagOpen;
    private Snippet body;
    private SnippetTag tagClose;
    private BlockTag renderer;

    public SnippetBlockTag(SnippetTag tagOpen, List<SnippetPart> bodyParts, SnippetTag tagClose, String origin) {
        super(tagOpen.snippetText, tagOpen.tag);
        this.tagOpen = tagOpen;
        this.tagClose = tagClose;
        this.body = new Snippet(bodyParts);
        this.body.setOrigin(origin);
        this.initBlockTag();
    }

    private void initBlockTag() {
        String tagName = this.tagOpen.tag;
        if (tagName.startsWith(".loop")) {
            this.renderer = new LoopTag(tagName, this.body);
        } else if (tagName.startsWith(".if")) {
            this.renderer = new IfTag(tagName, this.body);
        } else if (tagName.startsWith(".loc")) {
            this.renderer = new LocaleTag(tagName, this.body);
        } else if (tagName.startsWith(".exec")) {
            this.renderer = new MacroTag(tagName, this.body);
        }
    }

    @Override
    public void render(Writer out, Chunk context, String origin, int depth) throws IOException {
        if (this.depthCheckFails(depth, out)) {
            return;
        }
        if (this.renderer == null) {
            return;
        }
        this.renderer.renderBlock(out, context, origin, depth);
    }

    @Override
    public String toString() {
        return this.snippetText + this.body.toString() + this.tagClose.toString();
    }

    public SnippetTag getOpenTag() {
        return this.tagOpen;
    }

    public Snippet getBody() {
        return this.body;
    }

    public SnippetTag getCloseTag() {
        return this.tagClose;
    }

    public boolean doSmartTrimAroundBlock() {
        return this.renderer != null && this.renderer.doSmartTrimAroundBlock();
    }
}

