/*
 * Decompiled with CFR 0.152.
 */
package com.x5.template;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.x5.template.Attributes;
import com.x5.template.BlockTag;
import com.x5.template.Chunk;
import com.x5.template.ChunkFactory;
import com.x5.template.LoopTag;
import com.x5.template.Snippet;
import com.x5.template.SnippetPart;
import com.x5.template.SnippetTag;
import com.x5.util.LiteXml;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONValue;
import net.minidev.json.parser.ContainerFactory;
import net.minidev.json.parser.JSONParser;
import net.minidev.json.parser.ParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MacroTag
extends BlockTag {
    public static final String MACRO_MARKER = "exec";
    public static final String MACRO_END_MARKER = "/exec";
    private static final int ARG_START = "exec".length() + 2;
    private static final String FMT_XML = "xml";
    private static final String FMT_JSON_LAX = "json";
    private static final String FMT_JSON_STRICT = "json-strict";
    private static final String FMT_ORIGINAL = "original";
    private String templateRef;
    private Snippet template;
    private Map<String, Object> macroDefs;
    private String dataFormat = "original";
    private List<String> inputErrs = null;

    public MacroTag() {
    }

    public MacroTag(String tagName, Snippet body) {
        if (tagName.length() > ARG_START) {
            this.templateRef = tagName.substring(ARG_START).trim();
            int spacePos = this.templateRef.indexOf(32);
            if (spacePos > 0) {
                this.dataFormat = this.templateRef.substring(spacePos + 1).toLowerCase();
                if (this.dataFormat.charAt(0) == '@') {
                    this.dataFormat = this.dataFormat.substring(1);
                }
                this.templateRef = this.templateRef.substring(0, spacePos);
            }
            if (this.templateRef.charAt(0) == '@') {
                if (!this.templateRef.startsWith("@inline") && spacePos < 0) {
                    this.dataFormat = this.templateRef.substring(1).toLowerCase();
                }
                this.templateRef = null;
            }
        }
        Snippet bodyDouble = body.copy();
        if (this.templateRef == null) {
            this.parseInlineTemplate(bodyDouble);
        }
        this.parseDefs(bodyDouble);
    }

    private void parseInlineTemplate(Snippet body) {
        int bodyEnd;
        List<SnippetPart> parts = body.getParts();
        int eatUntil = bodyEnd = parts.size();
        for (int i = bodyEnd - 1; i >= 0; --i) {
            SnippetPart part = parts.get(i);
            if (!part.isTag()) continue;
            SnippetTag tag = (SnippetTag)part;
            if (tag.getTag().equals("./body")) {
                bodyEnd = i;
                eatUntil = i + 1;
                continue;
            }
            if (tag.getTag().startsWith(".data")) {
                bodyEnd = i;
                eatUntil = i;
                continue;
            }
            if (!tag.getTag().equals(".body")) continue;
            Snippet inlineSnippet = new Snippet(parts, i + 1, bodyEnd);
            inlineSnippet.setOrigin(body.getOrigin());
            List<SnippetPart> inlineParts = inlineSnippet.getParts();
            LoopTag.smartTrimSnippetParts(inlineParts, false);
            this.template = inlineSnippet;
            for (int j = eatUntil - 1; j >= i; --j) {
                parts.remove(j);
            }
            return;
        }
    }

    private void parseDefs(Snippet body) {
        body = this.stripCasing(body);
        if (this.dataFormat.equals(FMT_ORIGINAL)) {
            this.parseDefsOriginal(body);
        } else if (this.dataFormat.equals(FMT_JSON_STRICT)) {
            this.parseDefsJsonStrict(body);
        } else if (this.dataFormat.equals(FMT_JSON_LAX)) {
            this.parseDefsJsonLax(body);
        } else if (this.dataFormat.equals(FMT_XML)) {
            this.parseDefsXML(body);
        }
    }

    private Snippet stripCasing(Snippet body) {
        List<SnippetPart> parts = body.getParts();
        if (parts == null) {
            return body;
        }
        int dataStart = -1;
        int dataEnd = parts.size();
        for (int i = 0; i < dataEnd; ++i) {
            SnippetPart part = parts.get(i);
            if (!part.isTag()) continue;
            SnippetTag tag = (SnippetTag)part;
            String tagMeat = tag.getTag();
            if (tagMeat.startsWith(".data")) {
                this.parseDataFormat(tagMeat);
                dataStart = i;
                continue;
            }
            if (!tagMeat.equals("./data")) continue;
            dataEnd = i;
        }
        if (dataStart == -1) {
            return body;
        }
        Snippet dataSnippet = new Snippet(parts, dataStart + 1, dataEnd);
        if (this.templateRef == null && this.template == null) {
            List<SnippetPart> preData = parts.subList(0, dataStart);
            LoopTag.smartTrimSnippetParts(preData, false);
            if (dataEnd < parts.size()) {
                List<SnippetPart> postData = parts.subList(dataEnd + 1, parts.size());
                LoopTag.smartTrimSnippetParts(postData, false);
                parts.remove(dataEnd);
            }
            for (int i = dataEnd - 1; i >= dataStart; --i) {
                parts.remove(i);
            }
            this.template = body;
        }
        return dataSnippet;
    }

    private void parseDataFormat(String dataTag) {
        String params;
        if (dataTag.length() < 6) {
            return;
        }
        String format = params = dataTag.substring(5);
        Map<String, Object> opts = Attributes.parse(params);
        if (opts != null && opts.containsKey("format")) {
            format = (String)opts.get("format");
        }
        if ((format = format.trim()).startsWith("@")) {
            format = format.substring(1);
        }
        this.dataFormat = format;
    }

    private void parseDefsJsonLax(Snippet body) {
        body.setOrigin(null);
        String json = body.toString();
        try {
            Class.forName("net.minidev.json.JSONValue");
        }
        catch (ClassNotFoundException e) {
            try {
                Class.forName("com.fasterxml.jackson.databind.ObjectMapper");
                this.parseDefsJacksonJsonLax(json);
                return;
            }
            catch (ClassNotFoundException e2) {
                this.logInputError("Error: template uses json-formatted args in exec, but json-smart or jackson is not in the classpath!");
                return;
            }
        }
        Object parsedValue = JSONValue.parseKeepingOrder((String)json);
        if (parsedValue instanceof Map) {
            Map defs = (Map)parsedValue;
            this.importJSONDefs(defs);
        } else if (parsedValue instanceof JSONArray || parsedValue instanceof List) {
            this.logInputError("Error processing template: exec expected JSON object, not JSON array.");
        } else if (parsedValue instanceof String && parsedValue.toString().trim().length() > 0) {
            this.logInputError("Error processing template: exec expected JSON object.");
        }
    }

    private void parseDefsJsonStrict(Snippet body) {
        try {
            body.setOrigin(null);
            String json = body.toString();
            try {
                Class.forName("net.minidev.json.JSONValue");
            }
            catch (ClassNotFoundException e) {
                try {
                    Class.forName("com.fasterxml.jackson.databind.ObjectMapper");
                    this.parseDefsJacksonJsonStrict(json);
                    return;
                }
                catch (ClassNotFoundException e2) {
                    this.logInputError("Error: template uses json-formatted args in exec, but json-smart or jackson are not in the classpath!");
                    return;
                }
            }
            Object parsedValue = this.parseStrictJsonKeepingOrder(json);
            if (parsedValue instanceof Map) {
                Map defs = (Map)parsedValue;
                this.importJSONDefs(defs);
            } else if (parsedValue instanceof JSONArray || parsedValue instanceof List) {
                this.logInputError("Error processing template: exec expected JSON object, not JSON array.");
            } else if (parsedValue instanceof String && parsedValue.toString().trim().length() > 0) {
                this.logInputError("Error processing template: exec expected JSON object.");
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    private void parseDefsJacksonJsonLax(String json) {
        try {
            Map<String, Object> defs = JacksonJsonParser.parseJsonLax(json);
            this.importJSONDefs(defs);
        }
        catch (JsonParseException e) {
            this.logInputError(e.getMessage());
        }
    }

    private void parseDefsJacksonJsonStrict(String json) {
        try {
            Map<String, Object> defs = JacksonJsonParser.parseJsonStrict(json);
            this.importJSONDefs(defs);
        }
        catch (JsonParseException e) {
            this.logInputError(e.getMessage());
        }
    }

    private void logInputError(String errMsg) {
        if (this.inputErrs == null) {
            this.inputErrs = new ArrayList<String>();
        }
        this.inputErrs.add(errMsg);
    }

    private Object parseStrictJsonKeepingOrder(String json) throws ParseException {
        return new JSONParser(400).parse(json, ContainerFactory.FACTORY_ORDERED);
    }

    private void importJSONDefs(Map<String, Object> defs) {
        this.macroDefs = defs;
    }

    private void parseDefsXML(Snippet body) {
        body.setOrigin(null);
        LiteXml xml = new LiteXml(body.toString());
        this.macroDefs = this.parseXMLObject(xml);
    }

    private Map<String, Object> parseXMLObject(LiteXml xml) {
        LiteXml[] rules = xml.getChildNodes();
        if (rules == null) {
            return null;
        }
        HashMap<String, Object> tags = new HashMap<String, Object>();
        for (LiteXml rule : rules) {
            String tagName = rule.getNodeType();
            LiteXml[] children = rule.getChildNodes();
            if (children == null) {
                tags.put(tagName, rule.getNodeValue());
            } else {
                tags.put(tagName, this.parseXMLObject(rule));
            }
            Map<String, String> attrs = rule.getAttributes();
            if (attrs == null) continue;
            for (String key : attrs.keySet()) {
                tags.put(tagName + "@" + key, attrs.get(key));
            }
        }
        return tags;
    }

    private void parseDefsOriginal(Snippet body) {
        List<SnippetPart> parts = body.getParts();
        if (parts == null) {
            return;
        }
        for (int i = 0; i < parts.size(); ++i) {
            SnippetPart part = parts.get(i);
            if (!part.isTag()) continue;
            String tagText = ((SnippetTag)part).getTag();
            if (tagText.trim().endsWith("=")) {
                SnippetPart partJ;
                int j = this.findMatchingDefEnd(parts, i + 1);
                Snippet def = new Snippet(parts, i + 1, j);
                def.setOrigin(body.getOrigin());
                String varName = tagText.substring(0, tagText.length() - 1);
                this.saveDef(varName, def);
                i = j;
                if (j >= parts.size() || !(partJ = parts.get(j)).getText().equals("{=}")) continue;
                i = j + 1;
                continue;
            }
            String[] simpleDef = this.getSimpleDef(tagText);
            if (simpleDef == null) continue;
            this.saveDef(simpleDef[0], simpleDef[1], body.getOrigin());
        }
    }

    private int findMatchingDefEnd(List<SnippetPart> parts, int startAt) {
        int allTheRest = parts.size();
        for (int i = startAt; i < allTheRest; ++i) {
            String tagText;
            int eqPos;
            SnippetPart part = parts.get(i);
            if (!part.isTag() || (eqPos = (tagText = ((SnippetTag)part).getTag()).indexOf(61)) < 0) continue;
            if (tagText.length() == 1) {
                return i;
            }
            char[] tagChars = tagText.toCharArray();
            int c = 61;
            for (int x = 0; x < eqPos; ++x) {
                c = tagChars[x];
                if (c != 46 && c != 124 && c != 58 && c != 40) continue;
                c = 0;
                break;
            }
            if (c == 0) continue;
            return i;
        }
        return allTheRest;
    }

    private String[] getSimpleDef(String tagText) {
        int eqPos = tagText.indexOf(61);
        if (eqPos > -1) {
            String varName = tagText.substring(0, eqPos).trim();
            String varValue = tagText.substring(eqPos + 1);
            if (varValue.charAt(0) == ' ' && tagText.charAt(eqPos - 1) == ' ') {
                varValue = varValue.trim();
            }
            String[] assignment = new String[]{varName, varValue};
            return assignment;
        }
        return null;
    }

    private void saveDef(String tag, String def, String origin) {
        if (tag == null || def == null) {
            return;
        }
        Snippet simple = Snippet.getSnippet(def, origin);
        this.saveDef(tag, simple);
    }

    private void saveDef(String tag, Snippet snippet) {
        if (tag == null || snippet == null) {
            return;
        }
        if (this.macroDefs == null) {
            this.macroDefs = new HashMap<String, Object>();
        }
        this.macroDefs.put(tag, snippet);
    }

    @Override
    public void renderBlock(Writer out, Chunk context, String origin, int depth) throws IOException {
        Set<String> keys;
        Chunk macro = null;
        ChunkFactory theme = context.getChunkFactory();
        if (this.templateRef != null && theme != null) {
            this.templateRef = MacroTag.qualifyTemplateRef(origin, this.templateRef);
            macro = theme.makeChunk(this.templateRef);
        } else if (this.template != null) {
            macro = theme == null ? new Chunk() : theme.makeChunk();
            macro.append(this.template);
        } else {
            return;
        }
        if (this.inputErrs != null) {
            if (context.renderErrorsToOutput()) {
                for (String err : this.inputErrs) {
                    out.append('[');
                    out.append(err);
                    out.append(']');
                }
            }
            for (String err : this.inputErrs) {
                context.logError(err);
            }
        }
        if (this.macroDefs != null && (keys = this.macroDefs.keySet()) != null) {
            for (String tagName : keys) {
                Object o = this.macroDefs.get(tagName);
                macro.setOrDelete(tagName, this.resolvePointers(context, origin, o, 0));
            }
        }
        macro.render(out, context);
    }

    private Object resolvePointers(Chunk context, String origin, Object o, int depth) {
        Snippet s;
        if (depth > 10) {
            return o;
        }
        if (o instanceof String) {
            o = Snippet.getSnippet((String)o, origin);
        }
        if (o instanceof Snippet && (s = (Snippet)o).isSimplePointer()) {
            Object n = context.resolveTagValue(s.getPointerTag(), 1, origin);
            if (n == null) {
                return o;
            }
            o = this.resolvePointers(context, origin, n, depth + 1);
        }
        return o;
    }

    @Override
    public String getBlockStartMarker() {
        return MACRO_MARKER;
    }

    @Override
    public String getBlockEndMarker() {
        return MACRO_END_MARKER;
    }

    @Override
    public boolean doSmartTrimAroundBlock() {
        return true;
    }

    private static class JsonParseException
    extends Exception {
        public JsonParseException(String message, Throwable t) {
            super(message, t);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class JacksonJsonParser {
        private JacksonJsonParser() {
        }

        public static Map<String, Object> parseJsonLax(String json) throws JsonParseException {
            return JacksonJsonParser.parseJson(json, false);
        }

        public static Map<String, Object> parseJsonStrict(String json) throws JsonParseException {
            return JacksonJsonParser.parseJson(json, true);
        }

        private static Map<String, Object> parseJson(String json, boolean isStrict) throws JsonParseException {
            ObjectMapper mapper = new ObjectMapper();
            if (!isStrict) {
                mapper.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
                mapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
                mapper.configure(JsonParser.Feature.ALLOW_TRAILING_COMMA, true);
            }
            try {
                JsonNode node = mapper.readTree(json);
                if (node.isObject()) {
                    Map defs = (Map)mapper.convertValue((Object)node, (TypeReference)new TypeReference<TreeMap<String, Object>>(){});
                    return defs;
                }
                if (node.isArray()) {
                    throw new JsonParseException("Error processing template: exec expected JSON object, not JSON array.", null);
                }
                throw new JsonParseException("Error processing template: exec expected JSON object.", null);
            }
            catch (JsonProcessingException e) {
                throw new JsonParseException("Error processing template: exec expected JSON object.", e);
            }
        }
    }
}

